/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import org.apache.hadoop.hdfs.server.namenode.CheckableNameNodeResource;
import org.apache.hadoop.hdfs.server.namenode.NameNodeResourcePolicy;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNameNodeResourcePolicy {
    @Test
    public void testExcessiveMinimumRedundantResources() {
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(NameNodeResourcePolicy.class));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(1, 0, 0, 0, 2));
        logCapturer.stopCapturing();
        Assert.assertTrue((boolean)logCapturer.getOutput().contains("Resources not available."));
    }

    @Test
    public void testSingleRedundantResource() {
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(1, 0, 0, 0, 1));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(1, 0, 1, 0, 1));
    }

    @Test
    public void testSingleRequiredResource() {
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(0, 1, 0, 0, 0));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(0, 1, 0, 1, 0));
    }

    @Test
    public void testMultipleRedundantResources() {
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 0, 0, 4));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 1, 0, 4));
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 1, 0, 3));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 2, 0, 3));
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 2, 0, 2));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 3, 0, 2));
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 3, 0, 1));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(4, 0, 4, 0, 1));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(1, 0, 0, 0, 2));
    }

    @Test
    public void testMultipleRequiredResources() {
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(0, 3, 0, 0, 0));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(0, 3, 0, 1, 0));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(0, 3, 0, 2, 0));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(0, 3, 0, 3, 0));
    }

    @Test
    public void testRedundantWithRequiredResources() {
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(2, 2, 0, 0, 1));
        Assert.assertTrue((boolean)TestNameNodeResourcePolicy.testResourceScenario(2, 2, 1, 0, 1));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(2, 2, 2, 0, 1));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(2, 2, 0, 1, 1));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(2, 2, 1, 1, 1));
        Assert.assertFalse((boolean)TestNameNodeResourcePolicy.testResourceScenario(2, 2, 2, 1, 1));
    }

    private static boolean testResourceScenario(int numRedundantResources, int numRequiredResources, int numFailedRedundantResources, int numFailedRequiredResources, int minimumRedundantResources) {
        CheckableNameNodeResource r;
        int i;
        ArrayList<CheckableNameNodeResource> resources = new ArrayList<CheckableNameNodeResource>();
        for (i = 0; i < numRedundantResources; ++i) {
            r = (CheckableNameNodeResource)Mockito.mock(CheckableNameNodeResource.class);
            Mockito.when((Object)r.isRequired()).thenReturn((Object)false);
            Mockito.when((Object)r.isResourceAvailable()).thenReturn((Object)(i >= numFailedRedundantResources ? 1 : 0));
            resources.add(r);
        }
        for (i = 0; i < numRequiredResources; ++i) {
            r = (CheckableNameNodeResource)Mockito.mock(CheckableNameNodeResource.class);
            Mockito.when((Object)r.isRequired()).thenReturn((Object)true);
            Mockito.when((Object)r.isResourceAvailable()).thenReturn((Object)(i >= numFailedRequiredResources ? 1 : 0));
            resources.add(r);
        }
        return NameNodeResourcePolicy.areResourcesAvailable(resources, (int)minimumRedundantResources);
    }
}

