/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.reactivex.netty.client.PoolExhaustedException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

class ConnectionPoolExhaustedRetry
implements IDocumentClientRetryPolicy {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPoolExhaustedRetry.class);
    static final Duration RETRY_WAIT_TIME = Duration.ofMillis(10L);
    static final int MAX_RETRY_COUNT = 10;
    private int retryCount = 0;

    ConnectionPoolExhaustedRetry() {
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception e) {
        boolean isConnectionPoolExhaustedException = ConnectionPoolExhaustedRetry.isConnectionPoolExhaustedException(e);
        assert (isConnectionPoolExhaustedException);
        if (!isConnectionPoolExhaustedException) {
            logger.error("Fatal error invalid retry path for {}", (Object)e.getMessage(), (Object)e);
            return Single.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
        }
        if (++this.retryCount <= 10) {
            logger.warn("PoolExhaustedException failure indicates the load on the SDK is higher than what current connection pool size can support either increase the connection pool size for the configured connection mode, or distribute the load on more machines. retry count {}", (Object)this.retryCount);
            return Single.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(RETRY_WAIT_TIME));
        }
        logger.error("PoolExhaustedException failure indicates the load on the SDK is higher than what current connection pool size can support either increase the connection pool size for the configured connection mode, or distribute the load on more machines. All retries exhausted!");
        return Single.just((Object)IRetryPolicy.ShouldRetryResult.error(e));
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
    }

    static boolean isConnectionPoolExhaustedException(Exception ex) {
        while (ex != null) {
            if (ex instanceof PoolExhaustedException) {
                return true;
            }
            Throwable t = ex.getCause();
            if (!(t instanceof Exception)) break;
            ex = (Exception)t;
        }
        return false;
    }
}

