/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ServerProperties;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextRequest;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdFramer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdResponseStatus;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdToken;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdTokenStream;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;

public final class RntbdContext {
    private final RntbdResponseStatus frame;
    private final Headers headers;

    private RntbdContext(RntbdResponseStatus frame, Headers headers) {
        this.frame = frame;
        this.headers = headers;
    }

    static RntbdContext decode(ByteBuf in) throws TransportException {
        in.markReaderIndex();
        RntbdResponseStatus frame = RntbdResponseStatus.decode(in);
        int statusCode = frame.getStatusCode();
        int headersLength = frame.getHeadersLength();
        if (!(statusCode >= 200 && statusCode < 400 || RntbdFramer.canDecodePayload(in, in.readerIndex() + headersLength))) {
            in.resetReaderIndex();
            return null;
        }
        Headers headers = Headers.decode(in.readSlice(headersLength));
        if (statusCode < 200 || statusCode >= 400) {
            ObjectNode details = (ObjectNode)RntbdObjectMapper.readTree(in.readSlice(in.readIntLE()));
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            if (headers.clientVersion.isPresent()) {
                map.put("requiredClientVersion", headers.clientVersion.getValue());
            }
            if (headers.protocolVersion.isPresent()) {
                map.put("requiredProtocolVersion", headers.protocolVersion.getValue());
            }
            if (headers.serverAgent.isPresent()) {
                map.put("serverAgent", headers.serverAgent.getValue());
            }
            if (headers.serverVersion.isPresent()) {
                map.put("serverVersion", headers.serverVersion.getValue());
            }
            throw new TransportException(frame.getStatus(), details, Collections.unmodifiableMap(map));
        }
        return new RntbdContext(frame, headers);
    }

    public static RntbdContext from(RntbdContextRequest request, ServerProperties properties, HttpResponseStatus status) {
        Headers headers = new Headers();
        headers.clientVersion.setValue(request.getClientVersion());
        headers.idleTimeoutInSeconds.setValue(0);
        headers.protocolVersion.setValue(1);
        headers.serverAgent.setValue(properties.getAgent());
        headers.serverVersion.setValue(properties.getVersion());
        headers.unauthenticatedTimeoutInSeconds.setValue(0);
        int length = 24 + headers.computeLength();
        UUID activityId = request.getActivityId();
        RntbdResponseStatus frame = new RntbdResponseStatus(length, status, activityId);
        return new RntbdContext(frame, headers);
    }

    @JsonProperty
    UUID getActivityId() {
        return this.frame.getActivityId();
    }

    @JsonProperty
    String getClientVersion() {
        return this.headers.clientVersion.getValue(String.class);
    }

    @JsonProperty
    long getIdleTimeoutInSeconds() {
        return this.headers.idleTimeoutInSeconds.getValue(Long.class);
    }

    @JsonProperty
    int getProtocolVersion() {
        return this.headers.protocolVersion.getValue(Long.class).intValue();
    }

    @JsonProperty
    ServerProperties getServerProperties() {
        return new ServerProperties(this.headers.serverAgent.getValue(String.class), this.headers.serverVersion.getValue(String.class));
    }

    String getServerVersion() {
        return this.headers.serverVersion.getValue(String.class);
    }

    @JsonProperty
    int getStatusCode() {
        return this.frame.getStatusCode();
    }

    @JsonProperty
    long getUnauthenticatedTimeoutInSeconds() {
        return this.headers.unauthenticatedTimeoutInSeconds.getValue(Long.class);
    }

    public void encode(ByteBuf out) {
        int start = out.writerIndex();
        this.frame.encode(out);
        this.headers.encode(out);
        int length = out.writerIndex() - start;
        if (length != this.frame.getLength()) {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        ObjectWriter writer = RntbdObjectMapper.writer();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }

    private static final class Headers
    extends RntbdTokenStream<RntbdConstants.RntbdContextHeader> {
        RntbdToken clientVersion = this.get(RntbdConstants.RntbdContextHeader.ClientVersion);
        RntbdToken idleTimeoutInSeconds = this.get(RntbdConstants.RntbdContextHeader.IdleTimeoutInSeconds);
        RntbdToken protocolVersion = this.get(RntbdConstants.RntbdContextHeader.ProtocolVersion);
        RntbdToken serverAgent = this.get(RntbdConstants.RntbdContextHeader.ServerAgent);
        RntbdToken serverVersion = this.get(RntbdConstants.RntbdContextHeader.ServerVersion);
        RntbdToken unauthenticatedTimeoutInSeconds = this.get(RntbdConstants.RntbdContextHeader.UnauthenticatedTimeoutInSeconds);

        Headers() {
            super(RntbdConstants.RntbdContextHeader.set, RntbdConstants.RntbdContextHeader.map);
        }

        static Headers decode(ByteBuf in) {
            Headers headers = new Headers();
            Headers.decode(in, headers);
            return headers;
        }
    }
}

