/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.store.loaderwriter;

import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.shaded.org.ehcache.config.ResourceType;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.ServiceUtils;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.AbstractWrapperStoreProvider;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.Store;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.loaderwriter.LocalLoaderWriterStore;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.loaderwriter.LocalWriteBehindLoaderWriterStore;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriterProvider;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.WriteBehindProvider;
import org.apache.hadoop.shaded.org.ehcache.spi.service.Service;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceDependencies;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;

@ServiceDependencies(value={CacheLoaderWriterProvider.class, WriteBehindProvider.class})
public class LoaderWriterStoreProvider
extends AbstractWrapperStoreProvider {
    private volatile WriteBehindProvider writeBehindProvider;

    @Override
    protected <K, V> Store<K, V> wrap(Store<K, V> store, Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
        LocalLoaderWriterStore<K, V> loaderWriterStore;
        WriteBehindConfiguration writeBehindConfiguration = ServiceUtils.findSingletonAmongst(WriteBehindConfiguration.class, serviceConfigs);
        if (writeBehindConfiguration == null) {
            loaderWriterStore = new LocalLoaderWriterStore<K, V>(store, storeConfig.getCacheLoaderWriter(), storeConfig.useLoaderInAtomics(), storeConfig.getExpiry());
        } else {
            CacheLoaderWriter<K, V> writeBehindLoaderWriter = this.writeBehindProvider.createWriteBehindLoaderWriter(storeConfig.getCacheLoaderWriter(), writeBehindConfiguration);
            loaderWriterStore = new LocalWriteBehindLoaderWriterStore<K, V>(store, writeBehindLoaderWriter, storeConfig.useLoaderInAtomics(), storeConfig.getExpiry());
        }
        return loaderWriterStore;
    }

    @Override
    public void releaseStore(Store<?, ?> resource) {
        try {
            if (resource instanceof LocalWriteBehindLoaderWriterStore) {
                this.writeBehindProvider.releaseWriteBehindLoaderWriter(((LocalWriteBehindLoaderWriterStore)resource).getCacheLoaderWriter());
            }
        }
        finally {
            super.releaseStore(resource);
        }
    }

    @Override
    public void start(ServiceProvider<Service> serviceProvider) {
        super.start(serviceProvider);
        this.writeBehindProvider = serviceProvider.getService(WriteBehindProvider.class);
    }

    @Override
    public void stop() {
        this.writeBehindProvider = null;
        super.stop();
    }

    @Override
    public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        throw new UnsupportedOperationException("Its a Wrapper store provider, does not support regular ranking");
    }

    @Override
    public int wrapperStoreRank(Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
        CacheLoaderWriterConfiguration loaderWriterConfiguration = ServiceUtils.findSingletonAmongst(CacheLoaderWriterConfiguration.class, serviceConfigs);
        if (loaderWriterConfiguration == null) {
            return 0;
        }
        return 2;
    }
}

