/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.utils;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationMembershipStateStoreInputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationApplicationHomeSubClusterStoreInputValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FederationApplicationHomeSubClusterStoreInputValidator.class);

    private FederationApplicationHomeSubClusterStoreInputValidator() {
    }

    public static void validate(AddApplicationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing AddApplicationHomeSubCluster Request. Please try again by specifying an AddApplicationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationApplicationHomeSubClusterStoreInputValidator.checkApplicationHomeSubCluster(request.getApplicationHomeSubCluster());
    }

    public static void validate(UpdateApplicationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing UpdateApplicationHomeSubCluster Request. Please try again by specifying an ApplicationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationApplicationHomeSubClusterStoreInputValidator.checkApplicationHomeSubCluster(request.getApplicationHomeSubCluster());
    }

    public static void validate(GetApplicationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing GetApplicationHomeSubCluster Request. Please try again by specifying an Application Id information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationApplicationHomeSubClusterStoreInputValidator.checkApplicationId(request.getApplicationId());
    }

    public static void validate(DeleteApplicationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing DeleteApplicationHomeSubCluster Request. Please try again by specifying an ApplicationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationApplicationHomeSubClusterStoreInputValidator.checkApplicationId(request.getApplicationId());
    }

    private static void checkApplicationHomeSubCluster(ApplicationHomeSubCluster applicationHomeSubCluster) throws FederationStateStoreInvalidInputException {
        if (applicationHomeSubCluster == null) {
            String message = "Missing ApplicationHomeSubCluster Info. Please try again by specifying an ApplicationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationApplicationHomeSubClusterStoreInputValidator.checkApplicationId(applicationHomeSubCluster.getApplicationId());
        FederationMembershipStateStoreInputValidator.checkSubClusterId(applicationHomeSubCluster.getHomeSubCluster());
    }

    private static void checkApplicationId(ApplicationId appId) throws FederationStateStoreInvalidInputException {
        if (appId == null) {
            String message = "Missing Application Id. Please try again by specifying an Application Id.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }
}

