/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.ccache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.kerby.kerberos.kerb.ccache.CredCacheInputStream;
import org.apache.kerby.kerberos.kerb.ccache.CredCacheOutputStream;
import org.apache.kerby.kerberos.kerb.ccache.Credential;
import org.apache.kerby.kerberos.kerb.ccache.KrbCredentialCache;
import org.apache.kerby.kerberos.kerb.ccache.Tag;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.ticket.KrbTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;

public class CredentialCache
implements KrbCredentialCache {
    public static final int FCC_FVNO_1 = 1281;
    public static final int FCC_FVNO_2 = 1282;
    public static final int FCC_FVNO_3 = 1283;
    public static final int FCC_FVNO_4 = 1284;
    public static final int FCC_TAG_DELTATIME = 1;
    private final List<Credential> credentials = new ArrayList<Credential>();
    private int version = 1284;
    private List<Tag> tags;
    private PrincipalName primaryPrincipal;

    public CredentialCache() {
    }

    public CredentialCache(TgtTicket tgt) {
        this();
        this.addCredential(new Credential(tgt));
        this.setPrimaryPrincipal(tgt.getClientPrincipal());
    }

    public CredentialCache(SgtTicket sgt) {
        this();
        this.addCredential(new Credential((KrbTicket)sgt, sgt.getClientPrincipal()));
        this.setPrimaryPrincipal(sgt.getClientPrincipal());
    }

    public CredentialCache(Credential credential) {
        this();
        this.addCredential(credential);
        this.setPrimaryPrincipal(credential.getClientName());
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Dump credential cache file");
            System.err.println("Usage: CredentialCache <ccache-file>");
            System.exit(1);
        }
        String cacheFile = args[1];
        CredentialCache cc = new CredentialCache();
        cc.load(new File(cacheFile));
        for (Credential cred : cc.getCredentials()) {
            Ticket tkt = cred.getTicket();
            System.out.println("Tkt server name: " + tkt.getSname().getName());
            System.out.println("Tkt client name: " + cred.getClientName().getName());
            System.out.println("Tkt encrypt type: " + tkt.getEncryptedEncPart().getEType().getName());
        }
    }

    @Override
    public void store(File ccacheFile) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(ccacheFile.toPath(), new OpenOption[0]);){
            this.store(outputStream);
        }
    }

    @Override
    public void store(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Invalid and null output stream");
        }
        CredCacheOutputStream ccos = new CredCacheOutputStream(outputStream);
        this.doStore(ccos);
        ccos.close();
    }

    private void doStore(CredCacheOutputStream ccos) throws IOException {
        this.version = 1283;
        this.writeVersion(ccos);
        if (this.version == 1284) {
            this.writeTags(ccos);
        }
        ccos.writePrincipal(this.primaryPrincipal, this.version);
        for (Credential cred : this.credentials) {
            cred.store(ccos, this.version);
        }
    }

    @Override
    public PrincipalName getPrimaryPrincipal() {
        return this.primaryPrincipal;
    }

    @Override
    public void setPrimaryPrincipal(PrincipalName principal) {
        this.primaryPrincipal = principal;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public List<Credential> getCredentials() {
        return this.credentials;
    }

    @Override
    public void addCredential(Credential credential) {
        if (credential != null) {
            for (Credential cred : this.credentials) {
                if (!cred.getServerName().getName().equals(credential.getServerName().getName())) continue;
                return;
            }
            this.credentials.add(credential);
        }
    }

    @Override
    public void addCredentials(List<Credential> credentials) {
        if (credentials != null) {
            this.credentials.addAll(credentials);
        }
    }

    @Override
    public void removeCredentials(List<Credential> credentials) {
        if (credentials != null) {
            for (Credential cred : credentials) {
                this.removeCredential(cred);
            }
        }
    }

    @Override
    public void removeCredential(Credential credential) {
        if (credential != null) {
            for (Credential cred : this.credentials) {
                if (!cred.equals(credential)) continue;
                this.credentials.remove(cred);
                break;
            }
        }
    }

    @Override
    public void load(File ccacheFile) throws IOException {
        if (!ccacheFile.exists() || !ccacheFile.canRead()) {
            throw new IllegalArgumentException("Invalid ccache file: " + ccacheFile.getAbsolutePath());
        }
        try (InputStream inputStream = Files.newInputStream(ccacheFile.toPath(), new OpenOption[0]);){
            this.load(inputStream);
        }
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Invalid and null input stream");
        }
        CredCacheInputStream ccis = new CredCacheInputStream(inputStream);
        this.doLoad(ccis);
        ccis.close();
    }

    private void doLoad(CredCacheInputStream ccis) throws IOException {
        this.version = this.readVersion(ccis);
        if (this.version == 1284) {
            this.tags = this.readTags(ccis);
        }
        this.primaryPrincipal = ccis.readPrincipal(this.version);
        this.credentials.addAll(this.readCredentials(ccis));
    }

    private List<Credential> readCredentials(CredCacheInputStream ccis) throws IOException {
        ArrayList<Credential> results = new ArrayList<Credential>(2);
        while (ccis.available() > 0) {
            Credential cred = new Credential();
            cred.load(ccis, this.version);
            results.add(cred);
        }
        return results;
    }

    private int readVersion(CredCacheInputStream ccis) throws IOException {
        short result = ccis.readShort();
        return result;
    }

    private List<Tag> readTags(CredCacheInputStream ccis) throws IOException {
        short tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        block3: for (int len = ccis.readShort(); len > 0; len -= 4 + tagLen) {
            short tag = ccis.readShort();
            tagLen = ccis.readShort();
            switch (tag) {
                case 1: {
                    int time = ccis.readInt();
                    int usec = ccis.readInt();
                    tags.add(new Tag(tag, time, usec));
                    continue block3;
                }
                default: {
                    if (ccis.read(new byte[tagLen], 0, tagLen) != -1) continue block3;
                    throw new IOException();
                }
            }
        }
        return tags;
    }

    private void writeVersion(CredCacheOutputStream ccos) throws IOException {
        ccos.writeShort(this.version);
    }

    private void writeTags(CredCacheOutputStream ccos) throws IOException {
        if (this.tags == null) {
            ccos.writeShort(0);
            return;
        }
        int length = 0;
        for (Tag tag : this.tags) {
            if (tag.tag != 1) continue;
            length += tag.length;
        }
        ccos.writeShort(length);
        for (Tag tag : this.tags) {
            if (tag.tag != 1) continue;
            this.writeTag(ccos, tag);
        }
    }

    private void writeTag(CredCacheOutputStream ccos, Tag tag) throws IOException {
        ccos.writeShort(tag.tag);
        ccos.writeShort(tag.length);
        ccos.writeInt(tag.time);
        ccos.writeInt(tag.usec);
    }
}

