/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ptt.IsoDatePartitionFormat;
import io.questdb.cairo.ptt.IsoWeekPartitionFormat;
import io.questdb.griffin.SqlException;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.LowerCaseUtf8SequenceIntHashMap;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PartitionBy {
    public static final int DAY = 0;
    public static final int HOUR = 4;
    public static final int MONTH = 1;
    public static final int NONE = 3;
    public static final int WEEK = 5;
    public static final int YEAR = 2;
    private static final PartitionAddMethod ADD_DD = Timestamps::addDays;
    private static final PartitionAddMethod ADD_HH = Timestamps::addHours;
    private static final PartitionAddMethod ADD_MM = Timestamps::addMonths;
    private static final PartitionAddMethod ADD_WW = Timestamps::addWeeks;
    private static final PartitionAddMethod ADD_YYYY = Timestamps::addYears;
    private static final PartitionCeilMethod CEIL_DD = Timestamps::ceilDD;
    private static final PartitionCeilMethod CEIL_HH = Timestamps::ceilHH;
    private static final PartitionCeilMethod CEIL_MM = Timestamps::ceilMM;
    private static final PartitionCeilMethod CEIL_WW = Timestamps::ceilWW;
    private static final PartitionCeilMethod CEIL_YYYY = Timestamps::ceilYYYY;
    private static final DateFormat DEFAULT_FORMAT = new DateFormat(){

        @Override
        public void format(long datetime, @NotNull DateLocale locale, @Nullable CharSequence timeZoneName, @NotNull CharSink<?> sink) {
            sink.putAscii("default");
        }

        @Override
        public long parse(@NotNull CharSequence in, @NotNull DateLocale locale) {
            return this.parse(in, 0, in.length(), locale);
        }

        @Override
        public long parse(@NotNull CharSequence in, int lo, int hi, @NotNull DateLocale locale) {
            return 0L;
        }
    };
    private static final PartitionFloorMethod FLOOR_DD = Timestamps::floorDD;
    private static final PartitionFloorMethod FLOOR_HH = Timestamps::floorHH;
    private static final PartitionFloorMethod FLOOR_MM = Timestamps::floorMM;
    private static final PartitionFloorMethod FLOOR_WW = Timestamps::floorWW;
    private static final PartitionFloorMethod FLOOR_YYYY = Timestamps::floorYYYY;
    private static final DateFormat PARTITION_DAY_FORMAT = new IsoDatePartitionFormat(FLOOR_DD, TimestampFormatUtils.DAY_FORMAT);
    private static final DateFormat PARTITION_HOUR_FORMAT = new IsoDatePartitionFormat(FLOOR_HH, TimestampFormatUtils.HOUR_FORMAT);
    private static final DateFormat PARTITION_MONTH_FORMAT = new IsoDatePartitionFormat(FLOOR_MM, TimestampFormatUtils.MONTH_FORMAT);
    private static final DateFormat PARTITION_WEEK_FORMAT = new IsoWeekPartitionFormat();
    private static final DateFormat PARTITION_YEAR_FORMAT = new IsoDatePartitionFormat(FLOOR_YYYY, TimestampFormatUtils.YEAR_FORMAT);
    private static final LowerCaseCharSequenceIntHashMap nameToIndexMap = new LowerCaseCharSequenceIntHashMap();
    private static final LowerCaseUtf8SequenceIntHashMap nameToIndexMapUtf8 = new LowerCaseUtf8SequenceIntHashMap();
    private static final LowerCaseCharSequenceIntHashMap ttlUnitToIndexMap = new LowerCaseCharSequenceIntHashMap();

    private PartitionBy() {
    }

    public static int fromString(CharSequence name) {
        return nameToIndexMap.get(name);
    }

    public static int fromUtf8String(Utf8Sequence name) {
        return nameToIndexMapUtf8.get(name);
    }

    public static PartitionAddMethod getPartitionAddMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return ADD_DD;
            }
            case 1: {
                return ADD_MM;
            }
            case 2: {
                return ADD_YYYY;
            }
            case 4: {
                return ADD_HH;
            }
            case 5: {
                return ADD_WW;
            }
        }
        return null;
    }

    public static PartitionCeilMethod getPartitionCeilMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return CEIL_DD;
            }
            case 1: {
                return CEIL_MM;
            }
            case 2: {
                return CEIL_YYYY;
            }
            case 4: {
                return CEIL_HH;
            }
            case 5: {
                return CEIL_WW;
            }
        }
        return null;
    }

    public static DateFormat getPartitionDirFormatMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return PARTITION_DAY_FORMAT;
            }
            case 1: {
                return PARTITION_MONTH_FORMAT;
            }
            case 2: {
                return PARTITION_YEAR_FORMAT;
            }
            case 4: {
                return PARTITION_HOUR_FORMAT;
            }
            case 5: {
                return PARTITION_WEEK_FORMAT;
            }
            case 3: {
                return DEFAULT_FORMAT;
            }
        }
        throw new UnsupportedOperationException("partition by " + partitionBy + " does not have date format");
    }

    public static PartitionFloorMethod getPartitionFloorMethod(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return FLOOR_DD;
            }
            case 5: {
                return FLOOR_WW;
            }
            case 1: {
                return FLOOR_MM;
            }
            case 2: {
                return FLOOR_YYYY;
            }
            case 4: {
                return FLOOR_HH;
            }
        }
        return null;
    }

    public static boolean isPartitioned(int partitionBy) {
        return partitionBy != 3;
    }

    public static long parsePartitionDirName(@NotNull CharSequence partitionName, int partitionBy) {
        return PartitionBy.parsePartitionDirName(partitionName, partitionBy, 0, partitionName.length());
    }

    public static long parsePartitionDirName(@NotNull CharSequence partitionName, int partitionBy, int lo, int hi) {
        try {
            CharSequence fmtStr;
            DateFormat fmtMethod;
            switch (partitionBy) {
                case 0: {
                    fmtMethod = PARTITION_DAY_FORMAT;
                    fmtStr = "yyyy-MM-dd";
                    break;
                }
                case 1: {
                    fmtMethod = PARTITION_MONTH_FORMAT;
                    fmtStr = "yyyy-MM";
                    break;
                }
                case 2: {
                    fmtMethod = PARTITION_YEAR_FORMAT;
                    fmtStr = "yyyy";
                    break;
                }
                case 4: {
                    fmtMethod = PARTITION_HOUR_FORMAT;
                    fmtStr = "yyyy-MM-ddTHH";
                    break;
                }
                case 5: {
                    fmtMethod = PARTITION_WEEK_FORMAT;
                    fmtStr = "YYYY-Www";
                    break;
                }
                case 3: {
                    fmtMethod = DEFAULT_FORMAT;
                    fmtStr = partitionName;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("partition by " + partitionBy + " does not have date format");
                }
            }
            int limit = fmtStr.length();
            if (hi < 0) {
                hi = lo + Math.min(limit, partitionName.length());
            }
            if (hi - lo < limit) {
                throw PartitionBy.expectedPartitionDirNameFormatCairoException(partitionName, lo, hi, partitionBy);
            }
            return fmtMethod.parse(partitionName, lo, hi, DateFormatUtils.EN_LOCALE);
        }
        catch (NumericException e) {
            if (partitionBy == 5) {
                int localLimit = "yyyy-MM-dd".length();
                try {
                    return Timestamps.floorDOW(TimestampFormatUtils.DAY_FORMAT.parse(partitionName, 0, localLimit, DateFormatUtils.EN_LOCALE));
                }
                catch (NumericException ignore) {
                    throw PartitionBy.expectedPartitionDirNameFormatCairoException(partitionName, 0, Math.min(partitionName.length(), localLimit), partitionBy);
                }
            }
            throw PartitionBy.expectedPartitionDirNameFormatCairoException(partitionName, lo, hi, partitionBy);
        }
    }

    public static void setSinkForPartition(CharSink<?> path, int partitionBy, long timestamp) {
        if (partitionBy != 3) {
            PartitionBy.getPartitionDirFormatMethod(partitionBy).format(timestamp, DateFormatUtils.EN_LOCALE, null, path);
            return;
        }
        path.putAscii("default");
    }

    public static String toString(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return "DAY";
            }
            case 1: {
                return "MONTH";
            }
            case 2: {
                return "YEAR";
            }
            case 4: {
                return "HOUR";
            }
            case 5: {
                return "WEEK";
            }
            case 3: {
                return "NONE";
            }
        }
        return "UNKNOWN";
    }

    public static int ttlUnitFromString(CharSequence name, int start, int limit) {
        return ttlUnitToIndexMap.valueAt(ttlUnitToIndexMap.keyIndex(name, start, limit));
    }

    public static void validateTtlGranularity(int partitionBy, int ttlHoursOrMonths, int ttlValuePos) throws SqlException {
        switch (partitionBy) {
            case 3: {
                throw SqlException.position(ttlValuePos).put("cannot set TTL on a non-partitioned table");
            }
            case 0: {
                if (ttlHoursOrMonths >= 0 && ttlHoursOrMonths % 24 != 0) break;
                return;
            }
            case 5: {
                if (ttlHoursOrMonths >= 0 && ttlHoursOrMonths % 168 != 0) break;
                return;
            }
            case 1: {
                if (ttlHoursOrMonths >= 0) break;
                return;
            }
            case 2: {
                if (ttlHoursOrMonths >= 0 || ttlHoursOrMonths % 12 != 0) break;
                return;
            }
            default: {
                return;
            }
        }
        throw SqlException.position(ttlValuePos).put("TTL value must be an integer multiple of partition size");
    }

    private static CairoException expectedPartitionDirNameFormatCairoException(CharSequence partitionName, int lo, int hi, int partitionBy) {
        CairoException ee = CairoException.critical(0).put('\'');
        switch (partitionBy) {
            case 0: {
                ee.put("yyyy-MM-dd");
                break;
            }
            case 5: {
                ee.put("YYYY-Www").put("' or '").put("yyyy-MM-dd");
                break;
            }
            case 1: {
                ee.put("yyyy-MM");
                break;
            }
            case 2: {
                ee.put("yyyy");
                break;
            }
            case 4: {
                ee.put("yyyy-MM-ddTHH");
            }
        }
        ee.put("' expected, found [ts=").put(partitionName.subSequence(lo, hi)).put(']');
        return ee;
    }

    static {
        nameToIndexMap.put("day", 0);
        nameToIndexMap.put("month", 1);
        nameToIndexMap.put("year", 2);
        nameToIndexMap.put("hour", 4);
        nameToIndexMap.put("week", 5);
        nameToIndexMap.put("none", 3);
        nameToIndexMapUtf8.put(new Utf8String("day"), 0);
        nameToIndexMapUtf8.put(new Utf8String("month"), 1);
        nameToIndexMapUtf8.put(new Utf8String("year"), 2);
        nameToIndexMapUtf8.put(new Utf8String("hour"), 4);
        nameToIndexMapUtf8.put(new Utf8String("week"), 5);
        nameToIndexMapUtf8.put(new Utf8String("none"), 3);
        ttlUnitToIndexMap.put("h", 4);
        ttlUnitToIndexMap.put("hour", 4);
        ttlUnitToIndexMap.put("hours", 4);
        ttlUnitToIndexMap.put("d", 0);
        ttlUnitToIndexMap.put("day", 0);
        ttlUnitToIndexMap.put("days", 0);
        ttlUnitToIndexMap.put("w", 5);
        ttlUnitToIndexMap.put("week", 5);
        ttlUnitToIndexMap.put("weeks", 5);
        ttlUnitToIndexMap.put("m", 1);
        ttlUnitToIndexMap.put("month", 1);
        ttlUnitToIndexMap.put("months", 1);
        ttlUnitToIndexMap.put("y", 2);
        ttlUnitToIndexMap.put("year", 2);
        ttlUnitToIndexMap.put("years", 2);
    }

    @FunctionalInterface
    public static interface PartitionAddMethod {
        public long calculate(long var1, int var3);
    }

    @FunctionalInterface
    public static interface PartitionCeilMethod {
        public long ceil(long var1);
    }

    @FunctionalInterface
    public static interface PartitionFloorMethod {
        public long floor(long var1);
    }
}

