/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import org.jetbrains.annotations.Nullable;

public class TableColumnMetadata
implements Plannable {
    @Nullable
    private final RecordMetadata metadata;
    private final int replacingIndex;
    private final int symbolCapacity;
    private final boolean symbolTableStatic;
    private final int writerIndex;
    private String columnName;
    private int columnType;
    private boolean dedupKeyFlag;
    private int indexValueBlockCapacity;
    private boolean symbolCacheFlag;
    private boolean symbolIndexFlag;

    public TableColumnMetadata(String columnName, int columnType) {
        this(columnName, columnType, null);
    }

    public TableColumnMetadata(String columnName, int columnType, @Nullable RecordMetadata metadata) {
        this(columnName, columnType, false, 0, false, metadata, -1, false, 0, true, 0);
        assert (!ColumnType.isSymbol(columnType));
    }

    public TableColumnMetadata(String columnName, int columnType, boolean indexFlag, int indexValueBlockCapacity, boolean symbolTableStatic, @Nullable RecordMetadata metadata) {
        this(columnName, columnType, indexFlag, indexValueBlockCapacity, symbolTableStatic, metadata, -1, false, 0, true, 0);
    }

    public TableColumnMetadata(String columnName, int columnType, boolean symbolIndexFlag, int indexValueBlockCapacity, boolean symbolTableStatic, @Nullable RecordMetadata metadata, int writerIndex, boolean dedupKeyFlag) {
        this(columnName, columnType, symbolIndexFlag, indexValueBlockCapacity, symbolTableStatic, metadata, writerIndex, dedupKeyFlag, 0, true, 0);
    }

    public TableColumnMetadata(String columnName, int columnType, boolean symbolIndexFlag, int indexValueBlockCapacity, boolean symbolTableStatic, @Nullable RecordMetadata metadata, int writerIndex, boolean dedupKeyFlag, int replacingIndex, boolean symbolCacheFlag, int symbolCapacity) {
        this.columnName = columnName;
        this.columnType = columnType;
        this.symbolIndexFlag = symbolIndexFlag;
        this.indexValueBlockCapacity = indexValueBlockCapacity;
        this.symbolTableStatic = symbolTableStatic;
        this.metadata = GenericRecordMetadata.copyOf(metadata);
        this.writerIndex = writerIndex;
        this.dedupKeyFlag = dedupKeyFlag;
        this.replacingIndex = replacingIndex;
        this.symbolCacheFlag = symbolCacheFlag;
        this.symbolCapacity = symbolCapacity;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public int getIndexValueBlockCapacity() {
        return this.indexValueBlockCapacity;
    }

    @Nullable
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public int getReplacingIndex() {
        return this.replacingIndex;
    }

    public int getSymbolCapacity() {
        return this.symbolCapacity;
    }

    public int getWriterIndex() {
        return this.writerIndex;
    }

    public boolean isDedupKeyFlag() {
        return this.dedupKeyFlag;
    }

    public boolean isDeleted() {
        return this.columnType < 0;
    }

    public boolean isSymbolCacheFlag() {
        return this.symbolCacheFlag;
    }

    public boolean isSymbolIndexFlag() {
        return this.symbolIndexFlag;
    }

    public boolean isSymbolTableStatic() {
        return this.symbolTableStatic;
    }

    public void markDeleted() {
        this.columnType = -Math.abs(this.columnType);
    }

    public void rename(String name) {
        this.columnName = name;
    }

    public void setDedupKeyFlag(boolean dedupKeyFlag) {
        this.dedupKeyFlag = dedupKeyFlag;
    }

    public void setIndexValueBlockCapacity(int indexValueBlockCapacity) {
        this.indexValueBlockCapacity = indexValueBlockCapacity;
    }

    public void setSymbolCacheFlag(boolean cache) {
        this.symbolCacheFlag = cache;
    }

    public void setSymbolIndexFlag(boolean value) {
        this.symbolIndexFlag = value;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.columnName);
    }
}

