/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractTableNameRegistry;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableFlagResolver;
import io.questdb.cairo.TableToken;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;
import org.jetbrains.annotations.Nullable;

public class TableNameRegistryRO
extends AbstractTableNameRegistry {
    private final long autoReloadTimeout;
    private final MillisecondClock clockMs;
    private ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap1 = new ConcurrentHashMap();
    private ConcurrentHashMap<ReverseTableMapItem> dirNameToTableTokenMap2 = new ConcurrentHashMap();
    private volatile long lastReloadTimestampMs = 0L;
    private ConcurrentHashMap<TableToken> tableNameToTableTokenMap1 = new ConcurrentHashMap(false);
    private ConcurrentHashMap<TableToken> tableNameToTableTokenMap2 = new ConcurrentHashMap(false);

    public TableNameRegistryRO(CairoEngine engine, TableFlagResolver tableFlagResolver) {
        super(engine, tableFlagResolver);
        this.clockMs = engine.getConfiguration().getMillisecondClock();
        long timeout = engine.getConfiguration().getTableRegistryAutoReloadFrequency();
        this.autoReloadTimeout = timeout > 0L ? timeout : Long.MAX_VALUE;
        this.setNameMaps(this.tableNameToTableTokenMap1, this.dirNameToTableTokenMap1);
    }

    @Override
    public TableToken addTableAlias(String newName, TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public boolean dropTable(TableToken token) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public TableToken getTableToken(CharSequence tableName) {
        TableToken record = super.getTableToken(tableName);
        if (record == null && this.clockMs.getTicks() - this.lastReloadTimestampMs > this.autoReloadTimeout) {
            this.reloadThrottled();
            return super.getTableToken(tableName);
        }
        return record;
    }

    @Override
    public TableToken lockTableName(String tableName, String dirName, int tableId, boolean isMatView, boolean isWal) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public void purgeToken(TableToken token) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public void registerName(TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public synchronized boolean reload(@Nullable ObjList<TableToken> convertedTables) {
        this.tableNameToTableTokenMap2.clear();
        this.dirNameToTableTokenMap2.clear();
        boolean consistent = this.nameStore.reload(this.tableNameToTableTokenMap2, this.dirNameToTableTokenMap2, convertedTables);
        this.setNameMaps(this.tableNameToTableTokenMap2, this.dirNameToTableTokenMap2);
        ConcurrentHashMap<TableToken> tmp = this.tableNameToTableTokenMap2;
        this.tableNameToTableTokenMap2 = this.tableNameToTableTokenMap1;
        this.tableNameToTableTokenMap1 = tmp;
        ConcurrentHashMap<ReverseTableMapItem> tmp2 = this.dirNameToTableTokenMap2;
        this.dirNameToTableTokenMap2 = this.dirNameToTableTokenMap1;
        this.dirNameToTableTokenMap1 = tmp2;
        this.lastReloadTimestampMs = this.clockMs.getTicks();
        return consistent;
    }

    @Override
    public void removeAlias(TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public TableToken rename(CharSequence oldName, CharSequence newName, TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public void rename(TableToken alias, TableToken replaceWith) {
        throw CairoException.critical(0).put("instance is read only");
    }

    @Override
    public void unlockTableName(TableToken tableToken) {
        throw CairoException.critical(0).put("instance is read only");
    }

    private synchronized void reloadThrottled() {
        if (this.clockMs.getTicks() - this.lastReloadTimestampMs > this.autoReloadTimeout) {
            this.reload();
        }
    }
}

