/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.cairo.TxnScoreboardPool;
import io.questdb.cairo.TxnScoreboardV2;
import io.questdb.std.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NonNls;

public class TxnScoreboardPoolV2
implements TxnScoreboardPool {
    private final BiFunction<CharSequence, ScoreboardPoolTenant, ScoreboardPoolTenant> getOrCreateScoreboard;
    private final ConcurrentHashMap<ScoreboardPoolTenant> pool = new ConcurrentHashMap();

    public TxnScoreboardPoolV2(CairoConfiguration configuration) {
        this.getOrCreateScoreboard = (key, value) -> {
            if (value == null || !value.incrementRefCount()) {
                value = new ScoreboardPoolTenant(configuration.getReaderPoolMaxSegments() * 32);
            }
            return value;
        };
    }

    @Override
    public void clear() {
        for (CharSequence tableDir : this.pool.keySet()) {
            ScoreboardPoolTenant scoreboard = this.pool.get(tableDir);
            if (scoreboard == null) continue;
            this.pool.remove(tableDir, scoreboard);
            if (scoreboard.tryFullClose()) continue;
            scoreboard.closePending = true;
            scoreboard.tryFullClose();
        }
    }

    @Override
    public TxnScoreboard getTxnScoreboard(@NonNls TableToken token) {
        ScoreboardPoolTenant val = this.pool.compute(token.getDirName(), this.getOrCreateScoreboard);
        val.setTableToken(token);
        return val;
    }

    @Override
    public boolean releaseInactive() {
        boolean removed = false;
        for (CharSequence tableDir : this.pool.keySet()) {
            ScoreboardPoolTenant scoreboard = this.pool.get(tableDir);
            if (scoreboard == null || !scoreboard.tryFullClose()) continue;
            this.pool.remove(tableDir, scoreboard);
            removed = true;
        }
        return removed;
    }

    @Override
    public void remove(TableToken token) {
        ScoreboardPoolTenant scoreboard = this.pool.remove(token.getDirName());
        if (scoreboard != null) {
            scoreboard.closePending = true;
            scoreboard.tryFullClose();
        }
    }

    private static class ScoreboardPoolTenant
    extends TxnScoreboardV2 {
        private final AtomicInteger refCount = new AtomicInteger(1);
        private volatile boolean closePending = false;

        public ScoreboardPoolTenant(int entryCount) {
            super(entryCount);
        }

        @Override
        public void close() {
            if (this.refCount.decrementAndGet() == 0 && this.closePending) {
                this.tryFullClose();
            }
        }

        public boolean incrementRefCount() {
            int count;
            do {
                if ((count = this.refCount.get()) >= 0 && !this.closePending) continue;
                return false;
            } while (!this.refCount.compareAndSet(count, count + 1));
            return true;
        }

        public boolean tryFullClose() {
            if (this.refCount.compareAndSet(0, -1)) {
                super.close();
                return true;
            }
            return false;
        }
    }
}

