/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.TableToken;
import io.questdb.cairo.TxnScoreboard;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class TxnScoreboardV2
implements TxnScoreboard {
    private static final long UNLOCKED = -1L;
    private static final int VIRTUAL_ID_COUNT = 1;
    private static final int RESERVED_ID_COUNT = 4;
    private final int bitmapCount;
    private final int entryScanCount;
    private final int memSize;
    private long activeReaderCountMem;
    private long bitmapMem;
    private long entriesMem;
    private long maxMem;
    private long mem;
    private TableToken tableToken;

    public TxnScoreboardV2(int entryCount) {
        this.entryScanCount = entryCount + 1;
        long bitMapSize = this.entryScanCount + 64 - 1 & 0xFFFFFFC0;
        this.bitmapCount = (int)(bitMapSize / 64L);
        this.memSize = (entryCount + 4 + this.bitmapCount) * 8;
        this.activeReaderCountMem = this.mem = Unsafe.malloc(this.memSize, 55);
        this.maxMem = this.mem + 8L;
        this.bitmapMem = this.maxMem + 8L;
        this.entriesMem = this.bitmapMem + (long)(this.bitmapCount * 8);
        Vect.memset(this.entriesMem, (long)this.entryScanCount * 8L, -1);
        Vect.memset(this.mem, (2 + this.bitmapCount) * 8, 0);
    }

    @Override
    public boolean acquireTxn(int id, long txn) {
        long internalId = TxnScoreboardV2.toInternalId(id);
        assert (internalId < (long)this.entryScanCount);
        if (!this.updateMax(txn)) {
            return false;
        }
        if (Unsafe.getUnsafe().compareAndSwapLong(null, this.entriesMem + internalId * 8L, -1L, txn)) {
            this.incrementActiveReaderCount();
            this.setBitmapBit(internalId);
            if (this.getMax() > txn) {
                Unsafe.getUnsafe().putLongVolatile(null, this.entriesMem + internalId * 8L, -1L);
                Unsafe.getUnsafe().getAndAddLong(null, this.activeReaderCountMem, -1L);
                this.clearBitmapBit(internalId);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.mem = Unsafe.free(this.mem, this.memSize, 55);
        this.entriesMem = 0L;
        this.maxMem = 0L;
        this.activeReaderCountMem = 0L;
        this.bitmapMem = 0L;
    }

    public long getActiveReaderCount(long txn) {
        if (this.getActiveReaderCount() == 0L) {
            return 0L;
        }
        long count = 0L;
        for (int i = 0; i < this.bitmapCount; ++i) {
            long bitmap = Unsafe.getUnsafe().getLongVolatile(null, this.bitmapMem + (long)i * 8L);
            if (bitmap == 0L) continue;
            int base = i * 64;
            while (bitmap != 0L) {
                long lowestBit = Long.lowestOneBit(bitmap);
                int bit = Long.numberOfTrailingZeros(lowestBit);
                int internalId = base + bit;
                long lockedTxn = Unsafe.getUnsafe().getLongVolatile(null, this.entriesMem + (long)internalId * 8L);
                if (lockedTxn == txn) {
                    ++count;
                }
                bitmap ^= lowestBit;
            }
        }
        return count;
    }

    @Override
    public int getEntryCount() {
        return this.entryScanCount;
    }

    public long getMin() {
        if (this.getActiveReaderCount() == 0L) {
            return -1L;
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this.bitmapCount; ++i) {
            long bitmap = Unsafe.getUnsafe().getLongVolatile(null, this.bitmapMem + (long)i * 8L);
            if (bitmap == 0L) continue;
            int base = i * 64;
            while (bitmap != 0L) {
                long lowestBit = Long.lowestOneBit(bitmap);
                int bit = Long.numberOfTrailingZeros(lowestBit);
                int internalId = base + bit;
                long lockedTxn = Unsafe.getUnsafe().getLongVolatile(null, this.entriesMem + (long)internalId * 8L);
                if (lockedTxn > -1L) {
                    min = Math.min(min, lockedTxn);
                }
                bitmap ^= lowestBit;
            }
        }
        return min == Long.MAX_VALUE ? -1L : min;
    }

    @Override
    public TableToken getTableToken() {
        return this.tableToken;
    }

    @Override
    public boolean hasEarlierTxnLocks(long txn) {
        this.updateMax(txn);
        if (this.getActiveReaderCount() == 0L) {
            return false;
        }
        for (int i = 0; i < this.bitmapCount; ++i) {
            long bitmap = Unsafe.getUnsafe().getLongVolatile(null, this.bitmapMem + (long)i * 8L);
            if (bitmap == 0L) continue;
            int base = i * 64;
            while (bitmap != 0L) {
                long lowestBit = Long.lowestOneBit(bitmap);
                int bit = Long.numberOfTrailingZeros(lowestBit);
                int internalId = base + bit;
                long lockedTxn = Unsafe.getUnsafe().getLongVolatile(null, this.entriesMem + (long)internalId * 8L);
                if (lockedTxn > -1L && lockedTxn < txn) {
                    return true;
                }
                bitmap ^= lowestBit;
            }
        }
        return false;
    }

    @Override
    public boolean incrementTxn(int id, long txn) {
        long internalId = TxnScoreboardV2.toInternalId(id);
        assert (internalId < (long)this.entryScanCount);
        if (Unsafe.getUnsafe().compareAndSwapLong(null, this.entriesMem + internalId * 8L, -1L, txn)) {
            this.incrementActiveReaderCount();
            this.setBitmapBit(internalId);
            return true;
        }
        return false;
    }

    @Override
    public boolean isOutdated(long txn) {
        return txn < this.getMax();
    }

    @Override
    public boolean isRangeAvailable(long fromTxn, long toTxn) {
        this.updateMax(toTxn);
        if (this.getActiveReaderCount() == 0L) {
            return true;
        }
        for (int i = 0; i < this.bitmapCount; ++i) {
            long bitmap = Unsafe.getUnsafe().getLongVolatile(null, this.bitmapMem + (long)i * 8L);
            if (bitmap == 0L) continue;
            int base = i * 64;
            while (bitmap != 0L) {
                long lowestBit = Long.lowestOneBit(bitmap);
                int bit = Long.numberOfTrailingZeros(lowestBit);
                int internalId = base + bit;
                long lockedTxn = Unsafe.getUnsafe().getLongVolatile(null, this.entriesMem + (long)internalId * 8L);
                if (lockedTxn > -1L && lockedTxn >= fromTxn && lockedTxn < toTxn) {
                    return false;
                }
                bitmap ^= lowestBit;
            }
        }
        return true;
    }

    @Override
    public boolean isTxnAvailable(long txn) {
        if (this.getMax() <= txn) {
            return false;
        }
        if (this.getActiveReaderCount() == 0L) {
            return true;
        }
        for (int i = 0; i < this.bitmapCount; ++i) {
            long bitmap = Unsafe.getUnsafe().getLongVolatile(null, this.bitmapMem + (long)i * 8L);
            if (bitmap == 0L) continue;
            int base = i * 64;
            while (bitmap != 0L) {
                long lowestBit = Long.lowestOneBit(bitmap);
                int bit = Long.numberOfTrailingZeros(lowestBit);
                int internalId = base + bit;
                long lockedTxn = Unsafe.getUnsafe().getLongVolatile(null, this.entriesMem + (long)internalId * 8L);
                if (lockedTxn == txn) {
                    return false;
                }
                bitmap ^= lowestBit;
            }
        }
        return true;
    }

    @Override
    public long releaseTxn(int id, long txn) {
        long lockedTxn;
        long internalId = TxnScoreboardV2.toInternalId(id);
        assert (internalId < (long)this.entryScanCount);
        if (Unsafe.getUnsafe().compareAndSwapLong(null, this.entriesMem + internalId * 8L, txn, -1L)) {
            this.clearBitmapBit(internalId);
            Unsafe.getUnsafe().getAndAddLong(null, this.activeReaderCountMem, -1L);
        } else assert ((lockedTxn = Unsafe.getUnsafe().getLongVolatile(null, this.entriesMem + internalId * 8L)) == -1L) : "Invalid scoreboard release, expected " + txn + " but got " + lockedTxn;
        return 0L;
    }

    public void setTableToken(TableToken tableToken) {
        this.tableToken = tableToken;
    }

    private static int toInternalId(int id) {
        return id + 1;
    }

    private void clearBitmapBit(long internalId) {
        long l;
        long offset = this.bitmapMem + (internalId >>> 6) * 8L;
        long mask = 1L << (int)(internalId & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL;
        while (((l = Unsafe.getUnsafe().getLongVolatile(null, offset)) & mask) != l && !Unsafe.getUnsafe().compareAndSwapLong(null, offset, l, l & mask)) {
        }
    }

    private long getActiveReaderCount() {
        return Unsafe.getUnsafe().getLongVolatile(null, this.activeReaderCountMem);
    }

    private long getMax() {
        return Unsafe.getUnsafe().getLongVolatile(null, this.maxMem);
    }

    private void incrementActiveReaderCount() {
        Unsafe.getUnsafe().getAndAddLong(null, this.activeReaderCountMem, 1L);
    }

    private void setBitmapBit(long internalId) {
        long b;
        long offset = this.bitmapMem + (internalId >>> 6) * 8L;
        long mask = 1L << (int)(internalId & 0x3FL);
        while (((b = Unsafe.getUnsafe().getLongVolatile(null, offset)) & mask) == 0L && !Unsafe.getUnsafe().compareAndSwapLong(null, offset, b, b | mask)) {
        }
    }

    private boolean updateMax(long txn) {
        long max;
        do {
            if (txn >= (max = Unsafe.getUnsafe().getLongVolatile(null, this.maxMem))) continue;
            return false;
        } while (txn > max && !Unsafe.getUnsafe().compareAndSwapLong(null, this.maxMem, max, txn));
        return true;
    }
}

