/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.frm;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.frm.Frame;
import io.questdb.cairo.frm.FrameColumn;

public class FrameAlgebra {
    public static void append(Frame target, Frame source, int commitMode) {
        FrameAlgebra.append(target, source, 0L, source.getRowCount(), commitMode);
    }

    public static void append(Frame target, Frame source, long sourceLo, long sourceHi, int commitMode) {
        if (sourceLo < sourceHi) {
            int n = source.columnCount();
            for (int i = 0; i < n; ++i) {
                try (FrameColumn sourceColumn = source.createColumn(i);
                     FrameColumn targetColumn = target.createColumn(i);){
                    if (sourceColumn.getColumnType() < 0) continue;
                    FrameAlgebra.append(targetColumn, target.getRowCount(), sourceColumn, sourceLo, sourceHi, commitMode);
                    target.saveChanges(targetColumn);
                    continue;
                }
            }
            target.setRowCount(target.getRowCount() + (sourceHi - sourceLo));
        }
    }

    public static boolean isColumnReplaceIdentical(int columnIndex, Frame partitionFrame, long partitionLo, long partitionHi, Frame commitFrame, long commitLo, long commitHi, long mergeIndexAddr, long mergeIndexRows) {
        try (FrameColumn partitionColumn = partitionFrame.createColumn(columnIndex);
             FrameColumn commitColumn = commitFrame.createColumn(columnIndex);){
            if (partitionColumn.getColumnType() >= 0) {
                boolean bl = FrameAlgebra.isColumnReplaceIdentical(partitionColumn, partitionLo, partitionHi, commitColumn, commitLo, commitHi, mergeIndexAddr, mergeIndexRows);
                return bl;
            }
        }
        return true;
    }

    public static boolean isDesignatedTimestampColumnReplaceIdentical(int columnIndex, Frame partitionFrame, long partitionLo, long partitionHi, Frame commitFrame, long commitLo, long commitHi) {
        try (FrameColumn partitionColumn = partitionFrame.createColumn(columnIndex);){
            FrameColumn commitColumn = commitFrame.createColumn(columnIndex);
            try {
                assert (partitionColumn.getColumnTop() == 0L);
                long partitionDataAddr = partitionColumn.getContiguousDataAddr(partitionHi);
                long commitDataAddr = commitColumn.getContiguousDataAddr(commitHi);
                boolean bl = FrameAlgebra.isDesignatedTimestampColumnReplaceIdentical0(partitionDataAddr + partitionLo * 8L, commitDataAddr + commitLo * 8L * 2L, partitionHi - partitionLo);
                if (commitColumn != null) {
                    commitColumn.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (commitColumn != null) {
                    try {
                        commitColumn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private static void append(FrameColumn targetColumn, long targetRowCount, FrameColumn sourceColumn, long sourceLo, long sourceHi, int commitMode) {
        int columnType = sourceColumn.getColumnType();
        if (columnType != targetColumn.getColumnType()) {
            throw new UnsupportedOperationException();
        }
        long sourceColumnTop = sourceColumn.getColumnTop();
        long nullPaddingRowCount = Math.max(0L, Math.min(sourceColumnTop, sourceHi) - sourceLo);
        if (nullPaddingRowCount > 0L) {
            long targetColTop = targetColumn.getColumnTop();
            if (targetColTop == targetRowCount) {
                targetColumn.addTop(nullPaddingRowCount);
            } else {
                targetColumn.appendNulls(targetRowCount, nullPaddingRowCount, commitMode);
            }
        }
        if (sourceColumnTop < sourceHi) {
            targetColumn.append(targetRowCount + nullPaddingRowCount, sourceColumn, sourceLo + nullPaddingRowCount, sourceHi, commitMode);
        }
    }

    private static boolean isColumnReplaceIdentical(FrameColumn partitionColumn, long partitionLo, long partitionHi, FrameColumn commitColumn, long commitLo, long commitHi, long mergeIndexAddr, long mergeIndexRows) {
        long partitionAddrAux = partitionColumn.getContiguousAuxAddr(partitionHi);
        long partitionDataAddr = partitionColumn.getContiguousDataAddr(partitionHi);
        long commitAuxAddr = commitColumn.getContiguousAuxAddr(commitHi);
        long commitDataAddr = commitColumn.getContiguousDataAddr(commitHi);
        int columnType = partitionColumn.getColumnType();
        short columnTypeTag = ColumnType.tagOf(columnType);
        return FrameAlgebra.isColumnReplaceIdentical(columnTypeTag, ColumnType.isVarSize(columnType) ? -1 : ColumnType.sizeOf(columnType), partitionColumn.getColumnTop(), partitionLo, partitionHi, partitionAddrAux, partitionDataAddr, commitColumn.getColumnTop(), commitLo, commitHi, commitAuxAddr, commitDataAddr, mergeIndexAddr, mergeIndexRows, TableUtils.getNullLong(columnTypeTag, 0), TableUtils.getNullLong(columnTypeTag, 1), TableUtils.getNullLong(columnTypeTag, 2), TableUtils.getNullLong(columnTypeTag, 3));
    }

    private static native boolean isColumnReplaceIdentical(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, long var26, long var28, long var30, long var32);

    private static native boolean isDesignatedTimestampColumnReplaceIdentical0(long var0, long var2, long var4);
}

