/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.MapValueMergeFunction;
import io.questdb.cairo.map.OrderedMapCursor;
import io.questdb.cairo.map.OrderedMapFixedSizeCursor;
import io.questdb.cairo.map.OrderedMapFixedSizeRecord;
import io.questdb.cairo.map.OrderedMapRecord;
import io.questdb.cairo.map.OrderedMapValue;
import io.questdb.cairo.map.OrderedMapVarSizeCursor;
import io.questdb.cairo.map.OrderedMapVarSizeRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectIntList;
import io.questdb.std.Hash;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderedMap
implements Map,
Reopenable {
    static final long VAR_KEY_HEADER_SIZE = 4L;
    private static final long MAX_HEAP_SIZE = Integer.toUnsignedLong(-1) - 1L << 3;
    private static final int MIN_KEY_CAPACITY = 16;
    private final OrderedMapCursor cursor;
    private final int heapMemoryTag;
    private final Key key;
    private final long keyOffset;
    private final long keySize;
    private final int listMemoryTag;
    private final double loadFactor;
    private final int maxResizes;
    private final MergeFunction mergeRef;
    private final OrderedMapRecord record;
    private final OrderedMapValue value;
    private final OrderedMapValue value2;
    private final OrderedMapValue value3;
    private final int valueColumnCount;
    private final long valueSize;
    private int free;
    private long heapLimit;
    private long heapSize;
    private long heapStart;
    private long initialHeapSize;
    private int initialKeyCapacity;
    private long kPos;
    private int keyCapacity;
    private int mask;
    private int nResizes;
    private DirectIntList offsets;
    private int size = 0;

    public OrderedMap(long heapSize, @NotNull ColumnTypes keyTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(heapSize, keyTypes, null, keyCapacity, loadFactor, maxResizes);
    }

    public OrderedMap(long heapSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int memoryTag) {
        this(heapSize, keyTypes, valueTypes, keyCapacity, loadFactor, maxResizes, memoryTag, memoryTag);
    }

    public OrderedMap(long heapSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(heapSize, keyTypes, valueTypes, keyCapacity, loadFactor, maxResizes, 29, 30);
    }

    OrderedMap(long heapSize, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int heapMemoryTag, int listMemoryTag) {
        assert (heapSize > 3L);
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        try {
            this.heapMemoryTag = heapMemoryTag;
            this.listMemoryTag = listMemoryTag;
            this.initialHeapSize = heapSize;
            this.loadFactor = loadFactor;
            this.heapStart = this.kPos = Unsafe.malloc(heapSize, heapMemoryTag);
            this.heapSize = heapSize;
            this.heapLimit = this.heapStart + heapSize;
            this.keyCapacity = (int)((double)keyCapacity / loadFactor);
            this.keyCapacity = this.initialKeyCapacity = Math.max(Numbers.ceilPow2(this.keyCapacity), 16);
            this.mask = this.keyCapacity - 1;
            this.free = (int)((double)this.keyCapacity * loadFactor);
            this.offsets = new DirectIntList((long)this.keyCapacity << 1, listMemoryTag);
            this.offsets.setPos((long)this.keyCapacity << 1);
            this.offsets.zero(0);
            this.nResizes = 0;
            this.maxResizes = maxResizes;
            int keyColumnCount = keyTypes.getColumnCount();
            long keySize = 0L;
            for (int i = 0; i < keyColumnCount; ++i) {
                int columnType = keyTypes.getColumnType(i);
                int size = ColumnType.sizeOf(columnType);
                if (size > 0) {
                    keySize += (long)size;
                    continue;
                }
                keySize = -1L;
                break;
            }
            this.keySize = keySize;
            this.keyOffset = keySize != -1L ? 0L : 4L;
            long valueOffset = 0L;
            long[] valueOffsets = null;
            long valueSize = 0L;
            if (valueTypes != null) {
                this.valueColumnCount = valueTypes.getColumnCount();
                valueOffsets = new long[this.valueColumnCount];
                for (int i = 0; i < this.valueColumnCount; ++i) {
                    valueOffsets[i] = valueOffset;
                    int columnType = valueTypes.getColumnType(i);
                    int size = ColumnType.sizeOf(columnType);
                    if (size <= 0) {
                        this.close();
                        throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                    }
                    valueOffset += (long)size;
                    valueSize += (long)size;
                }
            } else {
                this.valueColumnCount = 0;
            }
            this.valueSize = valueSize;
            this.value = new OrderedMapValue(valueSize, valueOffsets);
            this.value2 = new OrderedMapValue(valueSize, valueOffsets);
            this.value3 = new OrderedMapValue(valueSize, valueOffsets);
            assert (keySize + valueSize <= this.heapLimit - this.heapStart) : "page size is too small to fit a single key";
            if (keySize == -1L) {
                OrderedMapVarSizeRecord varSizeRecord = new OrderedMapVarSizeRecord(valueSize, valueOffsets, this.value, keyTypes, valueTypes);
                this.record = varSizeRecord;
                this.cursor = new OrderedMapVarSizeCursor(varSizeRecord, this);
                this.key = new VarSizeKey();
                this.mergeRef = this::mergeVarSizeKey;
            } else {
                OrderedMapFixedSizeRecord fixedSizeRecord = new OrderedMapFixedSizeRecord(keySize, valueSize, valueOffsets, this.value, keyTypes, valueTypes);
                this.record = fixedSizeRecord;
                this.cursor = new OrderedMapFixedSizeCursor(fixedSizeRecord, this);
                this.key = new FixedSizeKey();
                this.mergeRef = this::mergeFixedSizeKey;
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        this.kPos = this.heapStart;
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.size = 0;
        this.offsets.zero(0);
        this.nResizes = 0;
    }

    @Override
    public void close() {
        Misc.free(this.offsets);
        if (this.heapStart != 0L) {
            this.heapStart = Unsafe.free(this.heapStart, this.heapSize, this.heapMemoryTag);
            this.kPos = 0L;
            this.heapLimit = 0L;
            this.free = 0;
            this.size = 0;
            this.heapSize = 0L;
            this.nResizes = 0;
        }
    }

    public long getAppendOffset() {
        return this.kPos;
    }

    @Override
    public MapRecordCursor getCursor() {
        return this.cursor.init(this.heapStart, this.heapLimit, this.size);
    }

    @Override
    public long getHeapSize() {
        return this.heapLimit - this.heapStart;
    }

    @Override
    public int getKeyCapacity() {
        return this.keyCapacity;
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public long getUsedHeapSize() {
        return this.kPos - this.heapStart;
    }

    public int getValueColumnCount() {
        return this.valueColumnCount;
    }

    @Override
    public boolean isOpen() {
        return this.heapStart != 0L;
    }

    @Override
    public void merge(Map srcMap, MapValueMergeFunction mergeFunc) {
        assert (this != srcMap);
        if (srcMap.size() == 0L) {
            return;
        }
        this.mergeRef.merge((OrderedMap)srcMap, mergeFunc);
    }

    @Override
    public void reopen(int keyCapacity, long heapSize) {
        if (this.heapStart == 0L) {
            keyCapacity = (int)((double)keyCapacity / this.loadFactor);
            this.initialKeyCapacity = Math.max(Numbers.ceilPow2(keyCapacity), 16);
            this.initialHeapSize = heapSize;
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void reopen() {
        if (this.heapStart == 0L) {
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void restoreInitialCapacity() {
        if (this.heapSize != this.initialHeapSize || this.keyCapacity != this.initialKeyCapacity) {
            try {
                this.heapSize = this.initialHeapSize;
                this.heapStart = this.kPos = Unsafe.realloc(this.heapStart, this.heapLimit - this.heapStart, this.heapSize, this.heapMemoryTag);
                this.heapLimit = this.heapStart + this.initialHeapSize;
                this.keyCapacity = this.initialKeyCapacity;
                this.keyCapacity = this.keyCapacity < 16 ? 16 : Numbers.ceilPow2(this.keyCapacity);
                this.mask = this.keyCapacity - 1;
                this.offsets.resetCapacity();
                this.offsets.setCapacity((long)this.keyCapacity << 1);
                this.offsets.setPos((long)this.keyCapacity << 1);
                this.clear();
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
        }
    }

    @Override
    public void setKeyCapacity(int newKeyCapacity) {
        long requiredCapacity = (long)((double)newKeyCapacity / this.loadFactor);
        if (requiredCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        this.rehash(Numbers.ceilPow2((int)requiredCapacity));
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public MapValue valueAt(long startAddress) {
        long keySize = this.keySize;
        if (keySize == -1L) {
            keySize = Unsafe.getUnsafe().getInt(startAddress);
        }
        return this.valueOf(startAddress, startAddress + this.keyOffset + keySize, false, this.value);
    }

    @Override
    public MapKey withKey() {
        return this.key.init();
    }

    private static int getHashCodeLo(DirectIntList offsets, int index) {
        return offsets.get((long)index << 1 | 1L);
    }

    private static long getOffset(DirectIntList offsets, int index) {
        return (long)offsets.get((long)index << 1) - 1L << 3;
    }

    private static void setHashCodeLo(DirectIntList offsets, int index, int hashCodeLo) {
        offsets.set((long)index << 1 | 1L, hashCodeLo);
    }

    private static void setOffset(DirectIntList offsets, int index, long offset) {
        offsets.set((long)index << 1, (int)((offset >> 3) + 1L));
    }

    private OrderedMapValue asNew(Key keyWriter, int index, int hashCodeLo, OrderedMapValue value) {
        this.kPos = Bytes.align8b(keyWriter.appendAddress + this.valueSize);
        OrderedMap.setOffset(this.offsets, index, keyWriter.startAddress - this.heapStart);
        OrderedMap.setHashCodeLo(this.offsets, index, hashCodeLo);
        ++this.size;
        if (--this.free == 0) {
            this.rehash();
        }
        return this.valueOf(keyWriter.startAddress, keyWriter.appendAddress, true, value);
    }

    private void mergeFixedSizeKey(OrderedMap srcMap, MapValueMergeFunction mergeFunc) {
        assert (this.keySize >= 0L);
        long entrySize = this.keySize + this.valueSize;
        long alignedEntrySize = Bytes.align8b(entrySize);
        int k = (int)(srcMap.offsets.size() >>> 1);
        block0: for (int i = 0; i < k; ++i) {
            long destOffset;
            long offset = OrderedMap.getOffset(srcMap.offsets, i);
            if (offset < 0L) continue;
            long srcStartAddress = srcMap.heapStart + offset;
            int hashCodeLo = OrderedMap.getHashCodeLo(srcMap.offsets, i);
            int index = hashCodeLo & this.mask;
            while ((destOffset = OrderedMap.getOffset(this.offsets, index)) > -1L) {
                long destStartAddress;
                if (hashCodeLo == OrderedMap.getHashCodeLo(this.offsets, index) && Vect.memeq(destStartAddress = this.heapStart + destOffset, srcStartAddress, this.keySize)) {
                    mergeFunc.merge(this.valueAt(destStartAddress), srcMap.valueAt(srcStartAddress));
                    continue block0;
                }
                index = index + 1 & this.mask;
            }
            if (this.kPos + entrySize > this.heapLimit) {
                this.resize(entrySize, this.kPos);
            }
            Vect.memcpy(this.kPos, srcStartAddress, entrySize);
            OrderedMap.setOffset(this.offsets, index, this.kPos - this.heapStart);
            OrderedMap.setHashCodeLo(this.offsets, index, hashCodeLo);
            this.kPos += alignedEntrySize;
            ++this.size;
            if (--this.free != 0) continue;
            this.rehash();
        }
    }

    private void mergeVarSizeKey(OrderedMap srcMap, MapValueMergeFunction mergeFunc) {
        assert (this.keySize == -1L);
        int k = (int)(srcMap.offsets.size() >>> 1);
        block0: for (int i = 0; i < k; ++i) {
            long destOffset;
            long offset = OrderedMap.getOffset(srcMap.offsets, i);
            if (offset < 0L) continue;
            long srcStartAddress = srcMap.heapStart + offset;
            int srcKeySize = Unsafe.getUnsafe().getInt(srcStartAddress);
            int hashCodeLo = OrderedMap.getHashCodeLo(srcMap.offsets, i);
            int index = hashCodeLo & this.mask;
            while ((destOffset = OrderedMap.getOffset(this.offsets, index)) > -1L) {
                if (hashCodeLo == OrderedMap.getHashCodeLo(this.offsets, index)) {
                    long destStartAddress = this.heapStart + destOffset;
                    if (Unsafe.getUnsafe().getInt(destStartAddress) == srcKeySize && Vect.memeq(destStartAddress + this.keyOffset, srcStartAddress + this.keyOffset, srcKeySize)) {
                        mergeFunc.merge(this.valueAt(destStartAddress), srcMap.valueAt(srcStartAddress));
                        continue block0;
                    }
                }
                index = index + 1 & this.mask;
            }
            long entrySize = this.keyOffset + (long)srcKeySize + this.valueSize;
            if (this.kPos + entrySize > this.heapLimit) {
                this.resize(entrySize, this.kPos);
            }
            Vect.memcpy(this.kPos, srcStartAddress, entrySize);
            OrderedMap.setOffset(this.offsets, index, this.kPos - this.heapStart);
            OrderedMap.setHashCodeLo(this.offsets, index, hashCodeLo);
            this.kPos = Bytes.align8b(this.kPos + entrySize);
            ++this.size;
            if (--this.free != 0) continue;
            this.rehash();
        }
    }

    private OrderedMapValue probe0(Key keyWriter, int index, int hashCodeLo, long keySize, OrderedMapValue value) {
        block1: {
            long offset;
            do {
                ++index;
                offset = OrderedMap.getOffset(this.offsets, index &= this.mask);
                if (offset <= -1L) break block1;
            } while (hashCodeLo != OrderedMap.getHashCodeLo(this.offsets, index) || !keyWriter.eq(offset));
            long startAddress = this.heapStart + offset;
            return this.valueOf(startAddress, startAddress + this.keyOffset + keySize, false, value);
        }
        return this.asNew(keyWriter, index, hashCodeLo, value);
    }

    private OrderedMapValue probeReadOnly(Key keyWriter, int index, int hashCodeLo, long keySize, OrderedMapValue value) {
        block1: {
            long offset;
            do {
                ++index;
                offset = OrderedMap.getOffset(this.offsets, index &= this.mask);
                if (offset <= -1L) break block1;
            } while (hashCodeLo != OrderedMap.getHashCodeLo(this.offsets, index) || !keyWriter.eq(offset));
            long startAddress = this.heapStart + offset;
            return this.valueOf(startAddress, startAddress + this.keyOffset + keySize, false, value);
        }
        return null;
    }

    private void rehash() {
        this.rehash((long)this.keyCapacity << 1);
    }

    private void rehash(long newKeyCapacity) {
        if (newKeyCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        if (newKeyCapacity <= (long)this.keyCapacity) {
            return;
        }
        this.mask = (int)newKeyCapacity - 1;
        DirectIntList newOffsets = new DirectIntList(newKeyCapacity << 1, this.listMemoryTag);
        newOffsets.setPos(newKeyCapacity << 1);
        newOffsets.zero(0);
        int k = (int)(this.offsets.size() >>> 1);
        for (int i = 0; i < k; ++i) {
            long offset = OrderedMap.getOffset(this.offsets, i);
            if (offset < 0L) continue;
            int hashCodeLo = OrderedMap.getHashCodeLo(this.offsets, i);
            int index = hashCodeLo & this.mask;
            while (OrderedMap.getOffset(newOffsets, index) > -1L) {
                index = index + 1 & this.mask;
            }
            OrderedMap.setOffset(newOffsets, index, offset);
            OrderedMap.setHashCodeLo(newOffsets, index, hashCodeLo);
        }
        this.offsets.close();
        this.offsets = newOffsets;
        this.free += (int)((double)(newKeyCapacity - (long)this.keyCapacity) * this.loadFactor);
        this.keyCapacity = (int)newKeyCapacity;
    }

    private long resize(long entrySize, long appendAddress) {
        assert (appendAddress >= this.heapStart);
        if (this.nResizes == this.maxResizes) {
            throw LimitOverflowException.instance().put("limit of ").put(this.maxResizes).put(" resizes exceeded in FastMap");
        }
        ++this.nResizes;
        long kCapacity = this.heapLimit - this.heapStart << 1;
        long target = appendAddress + entrySize - this.heapStart;
        if (kCapacity < target) {
            kCapacity = Numbers.ceilPow2(target);
        }
        if (kCapacity > MAX_HEAP_SIZE) {
            throw LimitOverflowException.instance().put("limit of ").put(MAX_HEAP_SIZE).put(" memory exceeded in FastMap");
        }
        long kAddress = Unsafe.realloc(this.heapStart, this.heapSize, kCapacity, this.heapMemoryTag);
        this.heapSize = kCapacity;
        long delta = kAddress - this.heapStart;
        this.kPos += delta;
        assert (this.kPos > 0L);
        this.heapStart = kAddress;
        this.heapLimit = kAddress + kCapacity;
        return delta;
    }

    private OrderedMapValue valueOf(long startAddress, long valueAddress, boolean newValue, OrderedMapValue value) {
        return value.of(startAddress, valueAddress, this.heapLimit, newValue);
    }

    long keySize() {
        return this.keySize;
    }

    long valueSize() {
        return this.valueSize;
    }

    class VarSizeKey
    extends Key {
        private long len;

        VarSizeKey() {
        }

        @Override
        public long commit() {
            this.len = this.appendAddress - this.startAddress - OrderedMap.this.keyOffset;
            Unsafe.getUnsafe().putInt(this.startAddress, (int)this.len);
            return this.len;
        }

        @Override
        public void copyFrom(MapKey srcKey) {
            VarSizeKey srcVarKey = (VarSizeKey)srcKey;
            this.copyFromRawKey(srcVarKey.startAddress + OrderedMap.this.keyOffset, srcVarKey.len);
        }

        @Override
        public void copyFromRawKey(long srcPtr, long srcSize) {
            this.checkCapacity(srcSize);
            Vect.memcpy(this.appendAddress, srcPtr, srcSize);
            this.appendAddress += srcSize;
        }

        @Override
        public long hash() {
            return Hash.hashMem64(this.startAddress + OrderedMap.this.keyOffset, this.len);
        }

        @Override
        public void putArray(ArrayView value) {
            long byteCount = ArrayTypeDriver.getPlainValueSize(value);
            this.checkCapacity(byteCount);
            long writtenBytes = ArrayTypeDriver.appendPlainValue(this.appendAddress, value);
            assert (writtenBytes == byteCount);
            this.appendAddress += byteCount;
        }

        @Override
        public void putBin(BinarySequence value) {
            if (value == null) {
                this.putVarSizeNull();
            } else {
                long len = value.length() + 4L;
                if (len > Integer.MAX_VALUE) {
                    throw CairoException.nonCritical().put("binary column is too large");
                }
                this.checkCapacity((int)len);
                int l = (int)(len - 4L);
                Unsafe.getUnsafe().putInt(this.appendAddress, l);
                value.copyTo(this.appendAddress + 4L, 0L, l);
                this.appendAddress += len;
            }
        }

        @Override
        public void putBool(boolean value) {
            this.checkCapacity(1L);
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
        }

        @Override
        public void putByte(byte value) {
            this.checkCapacity(1L);
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
        }

        @Override
        public void putChar(char value) {
            this.checkCapacity(2L);
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putDate(long value) {
            this.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            this.checkCapacity(8L);
            Unsafe.getUnsafe().putDouble(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putFloat(float value) {
            this.checkCapacity(4L);
            Unsafe.getUnsafe().putFloat(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putIPv4(int value) {
            this.putInt(value);
        }

        @Override
        public void putInt(int value) {
            this.checkCapacity(4L);
            Unsafe.getUnsafe().putInt(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putInterval(Interval interval) {
            this.checkCapacity(16L);
            Unsafe.getUnsafe().putLong(this.appendAddress, interval.getLo());
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, interval.getHi());
            this.appendAddress += 16L;
        }

        @Override
        public void putLong(long value) {
            this.checkCapacity(8L);
            Unsafe.getUnsafe().putLong(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putLong128(long lo, long hi) {
            this.checkCapacity(16L);
            Unsafe.getUnsafe().putLong(this.appendAddress, lo);
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, hi);
            this.appendAddress += 16L;
        }

        @Override
        public void putLong256(Long256 value) {
            this.checkCapacity(32L);
            Unsafe.getUnsafe().putLong(this.appendAddress, value.getLong0());
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, value.getLong1());
            Unsafe.getUnsafe().putLong(this.appendAddress + 16L, value.getLong2());
            Unsafe.getUnsafe().putLong(this.appendAddress + 24L, value.getLong3());
            this.appendAddress += 32L;
        }

        @Override
        public void putLong256(long l0, long l1, long l2, long l3) {
            this.checkCapacity(32L);
            Unsafe.getUnsafe().putLong(this.appendAddress, l0);
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, l1);
            Unsafe.getUnsafe().putLong(this.appendAddress + 16L, l2);
            Unsafe.getUnsafe().putLong(this.appendAddress + 24L, l3);
            this.appendAddress += 32L;
        }

        @Override
        public void putShort(short value) {
            this.checkCapacity(2L);
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putStr(CharSequence value) {
            if (value == null) {
                this.putVarSizeNull();
                return;
            }
            int len = value.length();
            this.checkCapacity(((long)len << 1) + 4L);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)i << 1), value.charAt(i));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            int len = hi - lo;
            this.checkCapacity(((long)len << 1) + 4L);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = lo; i < hi; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)(i - lo) << 1), value.charAt(i));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putStrLowerCase(CharSequence value) {
            if (value == null) {
                this.putVarSizeNull();
                return;
            }
            int len = value.length();
            this.checkCapacity(((long)len << 1) + 4L);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)i << 1), Character.toLowerCase(value.charAt(i)));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putStrLowerCase(CharSequence value, int lo, int hi) {
            int len = hi - lo;
            this.checkCapacity(((long)len << 1) + 4L);
            Unsafe.getUnsafe().putInt(this.appendAddress, len);
            this.appendAddress += 4L;
            for (int i = lo; i < hi; ++i) {
                Unsafe.getUnsafe().putChar(this.appendAddress + ((long)(i - lo) << 1), Character.toLowerCase(value.charAt(i)));
            }
            this.appendAddress += (long)len << 1;
        }

        @Override
        public void putTimestamp(long value) {
            this.putLong(value);
        }

        @Override
        public void putVarchar(Utf8Sequence value) {
            int byteCount = VarcharTypeDriver.getSingleMemValueByteCount(value);
            this.checkCapacity(byteCount);
            VarcharTypeDriver.appendPlainValue(this.appendAddress, value, false);
            this.appendAddress += (long)byteCount;
        }

        @Override
        public void skip(int bytes) {
            this.checkCapacity(bytes);
            this.appendAddress += (long)bytes;
        }

        private void putVarSizeNull() {
            this.checkCapacity(4L);
            Unsafe.getUnsafe().putInt(this.appendAddress, -1);
            this.appendAddress += 4L;
        }

        @Override
        protected boolean eq(long offset) {
            long a = OrderedMap.this.heapStart + offset;
            long b = this.startAddress;
            if (Unsafe.getUnsafe().getInt(a) != Unsafe.getUnsafe().getInt(b)) {
                return false;
            }
            return Vect.memeq(a + OrderedMap.this.keyOffset, b + OrderedMap.this.keyOffset, this.len);
        }
    }

    abstract class Key
    implements MapKey {
        protected long appendAddress;
        protected long startAddress;

        Key() {
        }

        @Override
        public MapValue createValue() {
            long keySize = this.commit();
            long hashCode = this.hash();
            return this.createValue(keySize, hashCode);
        }

        @Override
        public MapValue createValue(long hashCode) {
            long keySize = this.commit();
            return this.createValue(keySize, hashCode);
        }

        @Override
        public MapValue findValue() {
            return this.findValue(OrderedMap.this.value);
        }

        @Override
        public MapValue findValue2() {
            return this.findValue(OrderedMap.this.value2);
        }

        @Override
        public MapValue findValue3() {
            return this.findValue(OrderedMap.this.value3);
        }

        public Key init() {
            this.reset();
            return this;
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, this);
        }

        @Override
        public abstract void putLong256(long var1, long var3, long var5, long var7);

        @Override
        public void putRecord(Record value) {
        }

        public void reset() {
            this.startAddress = OrderedMap.this.kPos;
            this.appendAddress = OrderedMap.this.kPos + OrderedMap.this.keyOffset;
        }

        private MapValue createValue(long keySize, long hashCode) {
            int hashCodeLo = Numbers.decodeLowInt(hashCode);
            int index = hashCodeLo & OrderedMap.this.mask;
            long offset = OrderedMap.getOffset(OrderedMap.this.offsets, index);
            if (offset < 0L) {
                return OrderedMap.this.asNew(this, index, hashCodeLo, OrderedMap.this.value);
            }
            if (hashCodeLo == OrderedMap.getHashCodeLo(OrderedMap.this.offsets, index) && this.eq(offset)) {
                long startAddress = OrderedMap.this.heapStart + offset;
                return OrderedMap.this.valueOf(startAddress, startAddress + OrderedMap.this.keyOffset + keySize, false, OrderedMap.this.value);
            }
            return OrderedMap.this.probe0(this, index, hashCodeLo, keySize, OrderedMap.this.value);
        }

        private MapValue findValue(OrderedMapValue value) {
            long keySize = this.commit();
            long hashCode = this.hash();
            int hashCodeLo = Numbers.decodeLowInt(hashCode);
            int index = hashCodeLo & OrderedMap.this.mask;
            long offset = OrderedMap.getOffset(OrderedMap.this.offsets, index);
            if (offset < 0L) {
                return null;
            }
            if (hashCodeLo == OrderedMap.getHashCodeLo(OrderedMap.this.offsets, index) && this.eq(offset)) {
                long startAddress = OrderedMap.this.heapStart + offset;
                return OrderedMap.this.valueOf(startAddress, startAddress + OrderedMap.this.keyOffset + keySize, false, value);
            }
            return OrderedMap.this.probeReadOnly(this, index, hashCodeLo, keySize, value);
        }

        protected void checkCapacity(long requiredKeySize) {
            long requiredSize = requiredKeySize + OrderedMap.this.valueSize;
            if (this.appendAddress + requiredSize > OrderedMap.this.heapLimit) {
                long delta = OrderedMap.this.resize(requiredSize, this.appendAddress);
                this.startAddress += delta;
                this.appendAddress += delta;
            }
        }

        abstract void copyFromRawKey(long var1, long var3);

        protected abstract boolean eq(long var1);
    }

    @FunctionalInterface
    private static interface MergeFunction {
        public void merge(OrderedMap var1, MapValueMergeFunction var2);
    }

    class FixedSizeKey
    extends Key {
        FixedSizeKey() {
        }

        @Override
        public long commit() {
            assert (this.appendAddress <= this.startAddress + OrderedMap.this.keySize);
            return OrderedMap.this.keySize;
        }

        @Override
        public void copyFrom(MapKey srcKey) {
            FixedSizeKey srcFixedKey = (FixedSizeKey)srcKey;
            this.copyFromRawKey(srcFixedKey.startAddress, OrderedMap.this.keySize);
        }

        @Override
        public void copyFromRawKey(long srcPtr, long srcSize) {
            assert (srcSize == OrderedMap.this.keySize);
            Vect.memcpy(this.appendAddress, srcPtr, srcSize);
            this.appendAddress += srcSize;
        }

        @Override
        public long hash() {
            return Hash.hashMem64(this.startAddress, OrderedMap.this.keySize);
        }

        @Override
        public FixedSizeKey init() {
            super.init();
            this.checkCapacity(OrderedMap.this.keySize);
            return this;
        }

        @Override
        public void putArray(ArrayView view) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBin(BinarySequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBool(boolean value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
        }

        @Override
        public void putByte(byte value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
        }

        @Override
        public void putChar(char value) {
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putDate(long value) {
            this.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            Unsafe.getUnsafe().putDouble(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putFloat(float value) {
            Unsafe.getUnsafe().putFloat(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putIPv4(int value) {
            this.putInt(value);
        }

        @Override
        public void putInt(int value) {
            Unsafe.getUnsafe().putInt(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putInterval(Interval interval) {
            Unsafe.getUnsafe().putLong(this.appendAddress, interval.getLo());
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, interval.getHi());
            this.appendAddress += 16L;
        }

        @Override
        public void putLong(long value) {
            Unsafe.getUnsafe().putLong(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putLong128(long lo, long hi) {
            Unsafe.getUnsafe().putLong(this.appendAddress, lo);
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, hi);
            this.appendAddress += 16L;
        }

        @Override
        public void putLong256(Long256 value) {
            Unsafe.getUnsafe().putLong(this.appendAddress, value.getLong0());
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, value.getLong1());
            Unsafe.getUnsafe().putLong(this.appendAddress + 16L, value.getLong2());
            Unsafe.getUnsafe().putLong(this.appendAddress + 24L, value.getLong3());
            this.appendAddress += 32L;
        }

        @Override
        public void putLong256(long l0, long l1, long l2, long l3) {
            Unsafe.getUnsafe().putLong(this.appendAddress, l0);
            Unsafe.getUnsafe().putLong(this.appendAddress + 8L, l1);
            Unsafe.getUnsafe().putLong(this.appendAddress + 16L, l2);
            Unsafe.getUnsafe().putLong(this.appendAddress + 24L, l3);
            this.appendAddress += 32L;
        }

        @Override
        public void putShort(short value) {
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putStr(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putTimestamp(long value) {
            this.putLong(value);
        }

        @Override
        public void putVarchar(Utf8Sequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skip(int bytes) {
            this.appendAddress += (long)bytes;
        }

        @Override
        protected boolean eq(long offset) {
            return Vect.memeq(OrderedMap.this.heapStart + offset, this.startAddress, OrderedMap.this.keySize);
        }
    }
}

