/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.MapValueMergeFunction;
import io.questdb.cairo.map.Unordered2MapCursor;
import io.questdb.cairo.map.Unordered2MapRecord;
import io.questdb.cairo.map.Unordered2MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Unordered2Map
implements Map,
Reopenable {
    static final long KEY_SIZE = 2L;
    private static final int TABLE_CAPACITY = Short.toUnsignedInt((short)-1) + 1;
    private final Unordered2MapCursor cursor;
    private final long entrySize;
    private final Key key;
    private final int memoryTag;
    private final Unordered2MapRecord record;
    private final Unordered2MapValue value;
    private final Unordered2MapValue value2;
    private final Unordered2MapValue value3;
    private boolean hasZero;
    private long keyMemStart;
    private long memLimit;
    private long memStart;
    private int size = 0;

    public Unordered2Map(@NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes) {
        this(keyTypes, valueTypes, 60);
    }

    Unordered2Map(@NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int memoryTag) {
        try {
            this.memoryTag = memoryTag;
            int keyColumnCount = keyTypes.getColumnCount();
            long keySize = 0L;
            for (int i = 0; i < keyColumnCount; ++i) {
                int columnType = keyTypes.getColumnType(i);
                int size = ColumnType.sizeOf(columnType);
                if (size > 0) {
                    keySize += (long)size;
                    continue;
                }
                keySize = -1L;
                break;
            }
            if (keySize <= 0L || keySize > 2L) {
                throw CairoException.nonCritical().put("unexpected key size: ").put(keySize);
            }
            long valueOffset = 0L;
            long[] valueOffsets = null;
            long valueSize = 0L;
            if (valueTypes != null) {
                int valueColumnCount = valueTypes.getColumnCount();
                valueOffsets = new long[valueColumnCount];
                for (int i = 0; i < valueColumnCount; ++i) {
                    valueOffsets[i] = valueOffset;
                    int columnType = valueTypes.getColumnType(i);
                    int size = ColumnType.sizeOf(columnType);
                    if (size <= 0) {
                        throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                    }
                    valueOffset += (long)size;
                    valueSize += (long)size;
                }
            }
            this.entrySize = Bytes.align2b(2L + valueSize);
            long sizeBytes = this.entrySize * (long)TABLE_CAPACITY;
            this.memStart = Unsafe.malloc(sizeBytes, memoryTag);
            Vect.memset(this.memStart, sizeBytes, 0);
            this.memLimit = this.memStart + sizeBytes;
            this.keyMemStart = Unsafe.malloc(2L, memoryTag);
            Unsafe.getUnsafe().putShort(this.keyMemStart, (short)0);
            this.value = new Unordered2MapValue(valueSize, valueOffsets);
            this.value2 = new Unordered2MapValue(valueSize, valueOffsets);
            this.value3 = new Unordered2MapValue(valueSize, valueOffsets);
            this.record = new Unordered2MapRecord(valueSize, valueOffsets, this.value, keyTypes, valueTypes);
            this.cursor = new Unordered2MapCursor(this.record, this);
            this.key = new Key();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        this.hasZero = false;
        Vect.memset(this.memStart, this.entrySize * (long)TABLE_CAPACITY, 0);
        Unsafe.getUnsafe().putShort(this.keyMemStart, (short)0);
    }

    @Override
    public void close() {
        if (this.memStart != 0L) {
            this.memStart = this.memLimit = Unsafe.free(this.memStart, this.entrySize * (long)TABLE_CAPACITY, this.memoryTag);
            this.keyMemStart = Unsafe.free(this.keyMemStart, 2L, this.memoryTag);
            this.size = 0;
            this.hasZero = false;
        }
    }

    @Override
    public MapRecordCursor getCursor() {
        return this.cursor.init(this.memStart, this.memLimit, this.hasZero, this.size);
    }

    @Override
    public int getKeyCapacity() {
        return TABLE_CAPACITY;
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public boolean isOpen() {
        return this.memStart != 0L;
    }

    @Override
    public void merge(Map srcMap, MapValueMergeFunction mergeFunc) {
        assert (this != srcMap);
        long srcSize = srcMap.size();
        if (srcSize == 0L) {
            return;
        }
        Unordered2Map src2Map = (Unordered2Map)srcMap;
        if (src2Map.hasZero) {
            if (this.hasZero) {
                mergeFunc.merge(this.valueAt(this.memStart), src2Map.valueAt(src2Map.memStart));
            } else {
                Vect.memcpy(this.memStart, src2Map.memStart, this.entrySize);
                this.hasZero = true;
                ++this.size;
            }
            if (srcSize == 1L) {
                return;
            }
        }
        long destAddr = this.memStart + this.entrySize;
        long srcAddr = src2Map.memStart + this.entrySize;
        int i = 1;
        while (i < TABLE_CAPACITY) {
            short srcKey = Unsafe.getUnsafe().getShort(srcAddr);
            if (srcKey != 0) {
                short destKey = Unsafe.getUnsafe().getShort(destAddr);
                if (destKey != 0) {
                    mergeFunc.merge(this.valueAt(destAddr), src2Map.valueAt(srcAddr));
                } else {
                    Vect.memcpy(destAddr, srcAddr, this.entrySize);
                    ++this.size;
                }
            }
            ++i;
            destAddr += this.entrySize;
            srcAddr += this.entrySize;
        }
    }

    @Override
    public void reopen(int keyCapacity, long heapSize) {
        this.reopen();
    }

    @Override
    public void reopen() {
        if (this.memStart == 0L) {
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void restoreInitialCapacity() {
        if (this.memStart == 0L) {
            long sizeBytes = this.entrySize * (long)TABLE_CAPACITY;
            this.memStart = Unsafe.malloc(sizeBytes, this.memoryTag);
            this.memLimit = this.memStart + sizeBytes;
        }
        if (this.keyMemStart == 0L) {
            this.keyMemStart = Unsafe.malloc(2L, this.memoryTag);
        }
        this.clear();
    }

    @Override
    public void setKeyCapacity(int newKeyCapacity) {
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public MapValue valueAt(long startAddress) {
        return this.valueOf(startAddress, false, this.value);
    }

    @Override
    public MapKey withKey() {
        return this.key.init();
    }

    private long getStartAddress(short key) {
        return this.memStart + this.entrySize * (long)Short.toUnsignedInt(key);
    }

    private Unordered2MapValue valueOf(long startAddress, boolean newValue, Unordered2MapValue value) {
        return value.of(startAddress, this.memLimit, newValue);
    }

    long entrySize() {
        return this.entrySize;
    }

    boolean isZeroKey(long startAddress) {
        return Unsafe.getUnsafe().getShort(startAddress) == 0;
    }

    class Key
    implements MapKey {
        protected long appendAddress;

        Key() {
        }

        @Override
        public long commit() {
            assert (this.appendAddress <= Unordered2Map.this.keyMemStart + 2L);
            return 2L;
        }

        @Override
        public void copyFrom(MapKey srcKey) {
            Key src2Key = (Key)srcKey;
            this.copyFromRawKey(src2Key.startAddress());
        }

        @Override
        public MapValue createValue() {
            short key = Unsafe.getUnsafe().getShort(Unordered2Map.this.keyMemStart);
            if (key != 0) {
                long startAddress = Unordered2Map.this.getStartAddress(key);
                short k = Unsafe.getUnsafe().getShort(startAddress);
                Unordered2Map.this.size = Unordered2Map.this.size + (k == 0 ? 1 : 0);
                Unsafe.getUnsafe().putShort(startAddress, key);
                return Unordered2Map.this.valueOf(startAddress, k == 0, Unordered2Map.this.value);
            }
            if (Unordered2Map.this.hasZero) {
                return Unordered2Map.this.valueOf(Unordered2Map.this.memStart, false, Unordered2Map.this.value);
            }
            ++Unordered2Map.this.size;
            Unordered2Map.this.hasZero = true;
            return Unordered2Map.this.valueOf(Unordered2Map.this.memStart, true, Unordered2Map.this.value);
        }

        @Override
        public MapValue createValue(long hashCode) {
            return this.createValue();
        }

        @Override
        public MapValue findValue() {
            return this.findValue(Unordered2Map.this.value);
        }

        @Override
        public MapValue findValue2() {
            return this.findValue(Unordered2Map.this.value2);
        }

        @Override
        public MapValue findValue3() {
            return this.findValue(Unordered2Map.this.value3);
        }

        @Override
        public long hash() {
            return 0L;
        }

        public Key init() {
            this.appendAddress = Unordered2Map.this.keyMemStart;
            return this;
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, this);
        }

        @Override
        public void putArray(ArrayView view) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBin(BinarySequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBool(boolean value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
        }

        @Override
        public void putByte(byte value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
        }

        @Override
        public void putChar(char value) {
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putDate(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putDouble(double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putFloat(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putIPv4(int value) {
            this.putInt(value);
        }

        @Override
        public void putInt(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putInterval(Interval interval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong128(long lo, long hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(Long256 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(long l0, long l1, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putRecord(Record value) {
        }

        @Override
        public void putShort(short value) {
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putStr(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putTimestamp(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putVarchar(Utf8Sequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skip(int bytes) {
            this.appendAddress += (long)bytes;
        }

        private MapValue findValue(Unordered2MapValue value) {
            short key = Unsafe.getUnsafe().getShort(Unordered2Map.this.keyMemStart);
            if (key != 0) {
                long startAddress = Unordered2Map.this.getStartAddress(key);
                short k = Unsafe.getUnsafe().getShort(startAddress);
                return k != 0 ? Unordered2Map.this.valueOf(startAddress, false, value) : null;
            }
            return Unordered2Map.this.hasZero ? Unordered2Map.this.valueOf(Unordered2Map.this.memStart, false, value) : null;
        }

        void copyFromRawKey(long srcPtr) {
            short srcKey = Unsafe.getUnsafe().getShort(srcPtr);
            Unsafe.getUnsafe().putShort(this.appendAddress, srcKey);
            this.appendAddress += 2L;
        }

        long startAddress() {
            return Unordered2Map.this.keyMemStart;
        }
    }
}

