/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.arr.ArrayView;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Numbers;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.MutableUtf16Sink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.Nullable;

public interface Record {
    public static final CharSequenceFunction GET_STR = (record, col, sink) -> record.getStrA(col);
    public static final CharSequenceFunction GET_SYM = (record, col, sink) -> record.getSymA(col);
    public static final CharSequenceFunction GET_VARCHAR = (record, col, sink) -> {
        Utf8Sequence vch = record.getVarcharA(col);
        if (vch == null) {
            return null;
        }
        if (vch.isAscii()) {
            return vch.asAsciiCharSequence();
        }
        sink.clear();
        sink.put(vch);
        return sink;
    };

    default public ArrayView getArray(int col, int columnType) {
        throw new UnsupportedOperationException();
    }

    default public BinarySequence getBin(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getBinLen(int col) {
        throw new UnsupportedOperationException();
    }

    default public boolean getBool(int col) {
        throw new UnsupportedOperationException();
    }

    default public byte getByte(int col) {
        throw new UnsupportedOperationException();
    }

    default public char getChar(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getDate(int col) {
        return this.getLong(col);
    }

    default public double getDouble(int col) {
        throw new UnsupportedOperationException();
    }

    default public float getFloat(int col) {
        throw new UnsupportedOperationException();
    }

    default public byte getGeoByte(int col) {
        throw new UnsupportedOperationException();
    }

    default public int getGeoInt(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getGeoLong(int col) {
        throw new UnsupportedOperationException();
    }

    default public short getGeoShort(int col) {
        throw new UnsupportedOperationException();
    }

    default public int getIPv4(int col) {
        throw new UnsupportedOperationException();
    }

    default public int getInt(int col) {
        throw new UnsupportedOperationException();
    }

    default public Interval getInterval(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getLong(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getLong128Hi(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getLong128Lo(int col) {
        throw new UnsupportedOperationException();
    }

    default public void getLong256(int col, CharSink<?> sink) {
        throw new UnsupportedOperationException();
    }

    default public Long256 getLong256A(int col) {
        throw new UnsupportedOperationException();
    }

    default public Long256 getLong256B(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getLongIPv4(int col) {
        return Numbers.ipv4ToLong(this.getIPv4(col));
    }

    default public Record getRecord(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getRowId() {
        throw new UnsupportedOperationException();
    }

    default public short getShort(int col) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    default public CharSequence getStrA(int col) {
        throw new UnsupportedOperationException();
    }

    default public CharSequence getStrB(int col) {
        throw new UnsupportedOperationException();
    }

    default public int getStrLen(int col) {
        throw new UnsupportedOperationException();
    }

    default public CharSequence getSymA(int col) {
        throw new UnsupportedOperationException();
    }

    default public CharSequence getSymB(int col) {
        throw new UnsupportedOperationException();
    }

    default public long getTimestamp(int col) {
        return this.getLong(col);
    }

    default public long getUpdateRowId() {
        throw new UnsupportedOperationException();
    }

    default public void getVarchar(int col, Utf16Sink utf16Sink) {
        utf16Sink.put(this.getVarcharA(col));
    }

    @Nullable
    default public Utf8Sequence getVarcharA(int col) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    default public Utf8Sequence getVarcharB(int col) {
        throw new UnsupportedOperationException();
    }

    default public int getVarcharSize(int col) {
        throw new UnsupportedOperationException();
    }

    @FunctionalInterface
    public static interface CharSequenceFunction {
        public CharSequence get(Record var1, int var2, MutableUtf16Sink var3);
    }
}

