/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.processors.RejectProcessor;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8s;

public class HttpRequestValidator {
    public static final short ALL_CONTENT_TYPES = 32512;
    public static final short ALL_METHODS = 255;
    public static final short ALL = Short.MAX_VALUE;
    public static final short INVALID = Short.MIN_VALUE;
    public static final short METHOD_GET = 1;
    public static final short METHOD_POST = 2;
    public static final short METHOD_PUT = 4;
    public static final short NON_MULTIPART_REQUEST = 256;
    public static final short MULTIPART_REQUEST = 512;
    private boolean chunked;
    private long contentLength;
    private boolean multipart;
    private HttpRequestHeader requestHeader;
    private short requestType = (short)Short.MIN_VALUE;

    HttpRequestValidator() {
    }

    void of(HttpRequestHeader requestHeader) {
        this.requestHeader = requestHeader;
        this.contentLength = requestHeader.getContentLength();
        this.chunked = HttpKeywords.isChunked(requestHeader.getHeader(HttpConstants.HEADER_TRANSFER_ENCODING));
        this.multipart = HttpKeywords.isContentTypeMultipartFormData(requestHeader.getContentType()) || HttpKeywords.isContentTypeMultipartMixed(requestHeader.getContentType());
        this.requestType = (short)Short.MIN_VALUE;
    }

    void validateRequestHeader(RejectProcessor rejectProcessor) {
        if (rejectProcessor.isRequestBeingRejected()) {
            return;
        }
        if (this.requestHeader.getUrl() == null) {
            throw HttpException.instance("missing URL");
        }
        if (this.requestHeader.isGetRequest()) {
            if (this.chunked || this.multipart || this.contentLength > 0L) {
                rejectProcessor.reject(400, "GET request method cannot have content");
                return;
            }
            this.requestType = 1;
        } else if (this.requestHeader.isPostRequest() || this.requestHeader.isPutRequest()) {
            if (this.chunked && this.contentLength > 0L) {
                rejectProcessor.reject(400, "Invalid chunked request; content-length specified");
                return;
            }
            if (!this.chunked && this.contentLength < 0L) {
                rejectProcessor.reject(400, "Content-length not specified for POST/PUT request");
                return;
            }
            this.requestType = (short)(this.multipart ? 512 : 256);
            this.requestType = (short)(this.requestType | (this.requestHeader.isPostRequest() ? 2 : 4));
        }
    }

    HttpRequestProcessor validateRequestType(HttpRequestProcessor processor, RejectProcessor rejectProcessor) {
        if ((processor.getSupportedRequestTypes() & this.requestType) == this.requestType) {
            return processor;
        }
        DirectUtf8Sequence method = this.requestHeader.getMethod();
        if (method == null || Utf8s.equalsAscii("", method)) {
            rejectProcessor.getMessageSink().put("Method is not set in HTTP request");
            return rejectProcessor.reject(400);
        }
        if ((processor.getSupportedRequestTypes() & 0xFF & this.requestType) == 0) {
            rejectProcessor.getMessageSink().put("Method ").put(method).put(" not supported");
            return rejectProcessor.reject(405);
        }
        rejectProcessor.getMessageSink().put(this.multipart ? "Multipart " : "Non-multipart ").put(method).put(" not supported");
        return rejectProcessor.reject(400);
    }
}

