/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpAuthenticator;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

public final class StaticHttpAuthenticator
implements HttpAuthenticator {
    private final Utf8Sequence expectedHeader;
    private final String username;

    public StaticHttpAuthenticator(String username, Utf8Sequence expectedAuthHeader) {
        this.username = username;
        this.expectedHeader = expectedAuthHeader;
    }

    @Override
    public boolean authenticate(HttpRequestHeader headers) {
        DirectUtf8Sequence header = headers.getHeader(HttpConstants.HEADER_AUTHORIZATION);
        if (header == null) {
            return false;
        }
        return Utf8s.equals(this.expectedHeader, header);
    }

    @Override
    public CharSequence getPrincipal() {
        return this.username;
    }
}

