/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.PropServerConfiguration;
import io.questdb.ServerConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpPostPutProcessor;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.LocalValue;
import io.questdb.cutlass.http.processors.SettingsProcessorState;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.preferences.SettingsStore;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8StringSink;

public class SettingsProcessor
implements HttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(SettingsProcessor.class);
    private static final LocalValue<Utf8StringSink> LV_GET_SINK = new LocalValue();
    private static final LocalValue<SettingsProcessorState> LV_POST_STATE = new LocalValue();
    private static final String PREFERENCES_VERSION = "preferences.version";
    private static final Utf8String URL_PARAM_VERSION = new Utf8String("version");
    private final GetProcessor getProcessor = new GetProcessor();
    private final PostPutProcessor postPutProcessor = new PostPutProcessor();
    private final byte requiredAuthTypeForUpdate;
    private final ServerConfiguration serverConfiguration;
    private final SettingsStore settingsStore;

    public SettingsProcessor(CairoEngine engine, ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
        this.settingsStore = engine.getSettingsStore();
        this.requiredAuthTypeForUpdate = serverConfiguration.getHttpServerConfiguration().getJsonQueryProcessorConfiguration().getRequiredAuthType();
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return requestHeader.isGetRequest() ? this.getProcessor : this.postPutProcessor;
    }

    class GetProcessor
    implements HttpRequestProcessor {
        GetProcessor() {
        }

        @Override
        public byte getRequiredAuthType() {
            return 0;
        }

        @Override
        public boolean ignoreConnectionLimitCheck() {
            return true;
        }

        @Override
        public void onHeadersReady(HttpConnectionContext context) {
            Utf8StringSink settings = LV_GET_SINK.get(context);
            if (settings == null) {
                LOG.debug().$("new settings sink").$();
                LV_GET_SINK.set(context, new Utf8StringSink());
            }
        }

        @Override
        public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
            Utf8StringSink settings = LV_GET_SINK.get(context);
            settings.clear();
            settings.putAscii('{');
            SettingsProcessor.this.serverConfiguration.exportConfiguration(settings);
            PropServerConfiguration.JsonPropertyValueFormatter.integer(SettingsProcessor.PREFERENCES_VERSION, SettingsProcessor.this.settingsStore.getVersion(), settings);
            SettingsProcessor.this.settingsStore.exportPreferences(settings);
            settings.putAscii('}');
            context.simpleResponse().sendStatusJsonContent(200, settings, false);
        }

        @Override
        public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
            Utf8StringSink settings = LV_GET_SINK.get(context);
            context.simpleResponse().sendStatusJsonContent(200, settings, false);
        }
    }

    class PostPutProcessor
    implements HttpPostPutProcessor {
        private HttpConnectionContext transientContext;
        private SettingsProcessorState transientState;

        PostPutProcessor() {
        }

        @Override
        public byte getRequiredAuthType() {
            return SettingsProcessor.this.requiredAuthTypeForUpdate;
        }

        @Override
        public void onChunk(long lo, long hi) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
            if (hi > lo) {
                this.transientState.utf8Sink.putNonAscii(lo, hi);
            }
        }

        @Override
        public void onHeadersReady(HttpConnectionContext context) {
            this.transientContext = context;
            this.transientState = LV_POST_STATE.get(context);
            if (this.transientState == null) {
                LOG.debug().$("new settings state").$();
                this.transientState = new SettingsProcessorState(SettingsProcessor.this.serverConfiguration.getHttpServerConfiguration().getRecvBufferSize());
                LV_POST_STATE.set(context, this.transientState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
            try {
                context.getSecurityContext().authorizeSettings();
                SettingsStore.Mode mode = SettingsStore.Mode.of(context.getRequestHeader().getMethod());
                long version = this.parseVersion(context.getRequestHeader().getUrlParam(URL_PARAM_VERSION));
                SettingsProcessor.this.settingsStore.save(this.transientState.utf8Sink, mode, version);
                this.sendOk();
            }
            catch (CairoException e) {
                LOG.error().$("could not save preferences [msg=").$safe(e.getFlyweightMessage()).I$();
                this.sendErr(e);
            }
            catch (PeerDisconnectedException | PeerIsSlowToReadException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.critical().$("could not save preferences: ").$(e).I$();
                this.sendErr(e);
            }
            finally {
                this.transientState.clear();
            }
        }

        @Override
        public void resumeRecv(HttpConnectionContext context) {
            this.transientContext = context;
            this.transientState = LV_POST_STATE.get(context);
        }

        @Override
        public void resumeSend(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
            context.resumeResponseSend();
        }

        private long parseVersion(Utf8Sequence version) {
            try {
                return Numbers.parseLong(version);
            }
            catch (NumericException e) {
                LOG.error().$("could not parse version, numeric value expected [version='").$(version).$('\'').I$();
                throw CairoException.nonCritical().put("Invalid version, numeric value expected [version='").put(version).put("']");
            }
        }

        private void sendErr(CairoException e) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.transientState.utf8Sink.clear();
            this.transientState.utf8Sink.put("{\"error\":\"").escapeJsonStr(e.getFlyweightMessage()).put("\"}");
            this.transientContext.simpleResponse().sendStatusJsonContent(e.isPreferencesOutOfDateError() ? 409 : (e.isAuthorizationError() ? 401 : 400), this.transientState.utf8Sink);
        }

        private void sendErr(Throwable e) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.transientState.utf8Sink.clear();
            this.transientState.utf8Sink.put("{\"error\":\"").escapeJsonStr(e.getMessage()).put("\"}");
            this.transientContext.simpleResponse().sendStatusJsonContent(400, this.transientState.utf8Sink);
        }

        private void sendOk() throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.transientContext.simpleResponse().sendStatusJsonContent(200, Utf8String.EMPTY);
        }
    }
}

