/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.client.Sender;
import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class DelegatingTlsChannel
implements LineChannel {
    private static final long ADDRESS_FIELD_OFFSET;
    private static final int AFTER_HANDSHAKE = 1;
    private static final TrustManager[] BLIND_TRUST_MANAGERS;
    private static final long CAPACITY_FIELD_OFFSET;
    private static final int CLOSED = 3;
    private static final int CLOSING = 2;
    private static final int INITIAL_BUFFER_CAPACITY = 65536;
    private static final int INITIAL_STATE = 0;
    private static final long LIMIT_FIELD_OFFSET;
    private static final Log LOG;
    private final ByteBuffer dummyBuffer;
    private final SSLEngine sslEngine;
    private final ByteBuffer wrapInputBuffer;
    private LineChannel delegate;
    private int state = 0;
    private ByteBuffer unwrapInputBuffer;
    private long unwrapInputBufferPtr;
    private ByteBuffer unwrapOutputBuffer;
    private long unwrapOutputBufferPtr;
    private ByteBuffer wrapOutputBuffer;
    private long wrapOutputBufferPtr;

    public DelegatingTlsChannel(LineChannel delegate, String trustStorePath, char[] password, Sender.TlsValidationMode validationMode, String peerHost) {
        this.delegate = delegate;
        this.sslEngine = DelegatingTlsChannel.createSslEngine(trustStorePath, password, validationMode, peerHost);
        this.wrapInputBuffer = ByteBuffer.allocateDirect(0);
        int initialCapacity = Integer.getInteger("questdb.experimental.tls.buffersize", 65536);
        this.wrapOutputBuffer = ByteBuffer.allocateDirect(0);
        this.unwrapInputBuffer = ByteBuffer.allocateDirect(0);
        this.unwrapOutputBuffer = ByteBuffer.allocateDirect(0);
        this.wrapOutputBufferPtr = DelegatingTlsChannel.allocateMemoryAndResetBuffer(this.wrapOutputBuffer, initialCapacity);
        this.unwrapInputBufferPtr = DelegatingTlsChannel.allocateMemoryAndResetBuffer(this.unwrapInputBuffer, initialCapacity);
        this.unwrapOutputBufferPtr = DelegatingTlsChannel.allocateMemoryAndResetBuffer(this.unwrapOutputBuffer, initialCapacity);
        this.dummyBuffer = ByteBuffer.allocate(0);
        try {
            this.handshakeLoop();
        }
        catch (Throwable e) {
            this.close0(false);
            throw new LineSenderException("could not perform TLS handshake", e);
        }
    }

    @Override
    public void close() {
        this.close0(true);
    }

    public void close0(boolean closeDelegate) {
        int prevState = this.state;
        if (prevState == 3) {
            return;
        }
        this.state = 2;
        if (prevState == 1) {
            try {
                this.sslEngine.closeOutbound();
                this.wrapLoop(this.dummyBuffer);
                this.writeToUpstreamAndClear();
            }
            catch (Throwable e) {
                LOG.error().$("could not send TLS close_notify alert").$(e).$();
            }
        }
        this.state = 3;
        if (closeDelegate) {
            this.delegate = Misc.free(this.delegate);
        }
        int capacity = this.wrapOutputBuffer.capacity();
        long ptrToFree = this.wrapOutputBufferPtr;
        this.wrapOutputBuffer = null;
        this.wrapOutputBufferPtr = 0L;
        Unsafe.free(ptrToFree, capacity, 58);
        capacity = this.unwrapInputBuffer.capacity();
        ptrToFree = this.unwrapInputBufferPtr;
        this.unwrapInputBuffer = null;
        this.unwrapInputBufferPtr = 0L;
        Unsafe.free(ptrToFree, capacity, 58);
        capacity = this.unwrapOutputBuffer.capacity();
        ptrToFree = this.unwrapOutputBufferPtr;
        this.unwrapOutputBuffer = null;
        this.unwrapOutputBufferPtr = 0L;
        Unsafe.free(ptrToFree, capacity, 58);
    }

    @Override
    public int errno() {
        return this.delegate.errno();
    }

    @Override
    public int receive(long ptr, int len) {
        try {
            this.unwrapLoop();
            this.unwrapOutputBuffer.flip();
            int i = this.unwrapOutputBufferToPtr(ptr, len);
            this.unwrapOutputBuffer.compact();
            return i;
        }
        catch (SSLException e) {
            throw new LineSenderException("could not unwrap SSL packet", e);
        }
    }

    @Override
    public void send(long ptr, int len) {
        try {
            DelegatingTlsChannel.resetBufferToPointer(this.wrapInputBuffer, ptr, len);
            this.wrapInputBuffer.position(0);
            this.wrapLoop(this.wrapInputBuffer);
            assert (!this.wrapInputBuffer.hasRemaining());
        }
        catch (SSLException e) {
            throw new LineSenderException("error while sending data to questdb server", e);
        }
    }

    private static long allocateMemoryAndResetBuffer(ByteBuffer buffer, int capacity) {
        long newAddress = Unsafe.malloc(capacity, 58);
        DelegatingTlsChannel.resetBufferToPointer(buffer, newAddress, capacity);
        return newAddress;
    }

    private static SSLEngine createSslEngine(String trustStorePath, char[] trustStorePassword, Sender.TlsValidationMode validationMode, String peerHost) {
        assert (trustStorePath == null || validationMode == Sender.TlsValidationMode.DEFAULT);
        try {
            SSLContext sslContext;
            if (trustStorePath != null) {
                sslContext = SSLContext.getInstance("TLS");
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore jks = KeyStore.getInstance("JKS");
                try (InputStream trustStoreStream = DelegatingTlsChannel.openTruststoreStream(trustStorePath);){
                    jks.load(trustStoreStream, trustStorePassword);
                }
                tmf.init(jks);
                TrustManager[] trustManagers = tmf.getTrustManagers();
                sslContext.init(null, trustManagers, new SecureRandom());
            } else if (validationMode == Sender.TlsValidationMode.INSECURE) {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, BLIND_TRUST_MANAGERS, new SecureRandom());
            } else {
                sslContext = SSLContext.getDefault();
            }
            SSLEngine sslEngine = sslContext.createSSLEngine(peerHost, -1);
            if (validationMode != Sender.TlsValidationMode.INSECURE) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("https");
                sslEngine.setSSLParameters(sslParameters);
            }
            sslEngine.setUseClientMode(true);
            return sslEngine;
        }
        catch (Throwable t) {
            if (t instanceof LineSenderException) {
                throw (LineSenderException)t;
            }
            throw new LineSenderException("could not create SSL engine", t);
        }
    }

    private static long expandBuffer(ByteBuffer buffer, long oldAddress) {
        int oldCapacity = buffer.capacity();
        int newCapacity = oldCapacity * 2;
        long newAddress = Unsafe.realloc(oldAddress, oldCapacity, newCapacity, 58);
        DelegatingTlsChannel.resetBufferToPointer(buffer, newAddress, newCapacity);
        return newAddress;
    }

    private static InputStream openTruststoreStream(String trustStorePath) throws FileNotFoundException {
        if (trustStorePath.startsWith("classpath:")) {
            String adjustedPath = trustStorePath.substring("classpath:".length());
            InputStream trustStoreStream = DelegatingTlsChannel.class.getResourceAsStream(adjustedPath);
            if (trustStoreStream == null) {
                throw new LineSenderException((CharSequence)"configured trust store is unavailable ").put("[path=").put(trustStorePath).put("]");
            }
            return trustStoreStream;
        }
        return new FileInputStream(trustStorePath);
    }

    private static void resetBufferToPointer(ByteBuffer buffer, long ptr, int len) {
        assert (buffer.isDirect());
        Unsafe.getUnsafe().putLong(buffer, ADDRESS_FIELD_OFFSET, ptr);
        Unsafe.getUnsafe().putLong(buffer, LIMIT_FIELD_OFFSET, len);
        Unsafe.getUnsafe().putLong(buffer, CAPACITY_FIELD_OFFSET, len);
    }

    private void growUnwrapInputBuffer() {
        this.unwrapInputBufferPtr = DelegatingTlsChannel.expandBuffer(this.unwrapInputBuffer, this.unwrapInputBufferPtr);
    }

    private void growUnwrapOutputBuffer() {
        this.unwrapOutputBufferPtr = DelegatingTlsChannel.expandBuffer(this.unwrapOutputBuffer, this.unwrapOutputBufferPtr);
    }

    private void growWrapOutputBuffer() {
        this.wrapOutputBufferPtr = DelegatingTlsChannel.expandBuffer(this.wrapOutputBuffer, this.wrapOutputBufferPtr);
    }

    private void handshakeLoop() throws SSLException {
        SSLEngineResult.HandshakeStatus status;
        if (this.state != 0) {
            return;
        }
        this.sslEngine.beginHandshake();
        block7: while (true) {
            status = this.sslEngine.getHandshakeStatus();
            switch (status) {
                case NOT_HANDSHAKING: {
                    this.state = 1;
                    return;
                }
                case NEED_TASK: {
                    this.sslEngine.getDelegatedTask().run();
                    continue block7;
                }
                case NEED_WRAP: {
                    this.wrapLoop(this.dummyBuffer);
                    continue block7;
                }
                case NEED_UNWRAP: {
                    this.unwrapLoop();
                    continue block7;
                }
                case FINISHED: {
                    throw new LineSenderException((CharSequence)"getHandshakeStatus() returned FINISHED. It should not have been possible.");
                }
            }
            break;
        }
        throw new LineSenderException((CharSequence)(String.valueOf((Object)status) + "not supported"));
    }

    private void readFromUpstream(boolean force) {
        if (this.unwrapInputBuffer.position() != 0 && !force) {
            return;
        }
        assert (this.unwrapInputBuffer.limit() == this.unwrapInputBuffer.capacity());
        int remainingLen = this.unwrapInputBuffer.remaining();
        if (remainingLen == 0) {
            this.growUnwrapInputBuffer();
            remainingLen = this.unwrapInputBuffer.remaining();
        }
        assert (Unsafe.getUnsafe().getLong(this.unwrapInputBuffer, ADDRESS_FIELD_OFFSET) == this.unwrapInputBufferPtr);
        long adjustedPtr = this.unwrapInputBufferPtr + (long)this.unwrapInputBuffer.position();
        int receive = this.delegate.receive(adjustedPtr, remainingLen);
        if (receive < 0) {
            throw new LineSenderException((CharSequence)"connection closed");
        }
        this.unwrapInputBuffer.position(this.unwrapInputBuffer.position() + receive);
    }

    private void unwrapLoop() throws SSLException {
        while (this.unwrapOutputBuffer.position() == 0) {
            this.readFromUpstream(false);
            this.unwrapInputBuffer.flip();
            SSLEngineResult result = this.sslEngine.unwrap(this.unwrapInputBuffer, this.unwrapOutputBuffer);
            this.unwrapInputBuffer.compact();
            switch (result.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    this.readFromUpstream(true);
                    break;
                }
                case BUFFER_OVERFLOW: {
                    if (this.unwrapOutputBuffer.position() != 0) {
                        return;
                    }
                    this.growUnwrapOutputBuffer();
                    break;
                }
                case OK: {
                    return;
                }
                case CLOSED: {
                    throw new LineSenderException((CharSequence)"server closed connection unexpectedly");
                }
            }
        }
    }

    private int unwrapOutputBufferToPtr(long dstPtr, int dstLen) {
        int oldPosition = this.unwrapOutputBuffer.position();
        assert (Unsafe.getUnsafe().getLong(this.unwrapOutputBufferPtr, ADDRESS_FIELD_OFFSET) == this.unwrapOutputBufferPtr);
        long srcPtr = this.unwrapOutputBufferPtr + (long)oldPosition;
        int srcLen = this.unwrapOutputBuffer.remaining();
        int len = Math.min(dstLen, srcLen);
        Vect.memcpy(dstPtr, srcPtr, len);
        this.unwrapOutputBuffer.position(oldPosition + len);
        return len;
    }

    private void wrapLoop(ByteBuffer src) throws SSLException {
        do {
            SSLEngineResult result = this.sslEngine.wrap(src, this.wrapOutputBuffer);
            switch (result.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    throw new LineSenderException((CharSequence)"should not happen");
                }
                case BUFFER_OVERFLOW: {
                    this.growWrapOutputBuffer();
                    break;
                }
                case OK: {
                    this.writeToUpstreamAndClear();
                    break;
                }
                case CLOSED: {
                    if (this.state != 2) {
                        throw new LineSenderException((CharSequence)"server closed connection unexpectedly");
                    }
                    return;
                }
            }
        } while (src.hasRemaining());
    }

    private void writeToUpstreamAndClear() {
        assert (this.wrapOutputBuffer.limit() == this.wrapOutputBuffer.capacity());
        int len = this.wrapOutputBuffer.position();
        assert (Unsafe.getUnsafe().getLong(this.wrapOutputBuffer, ADDRESS_FIELD_OFFSET) == this.wrapOutputBufferPtr);
        this.delegate.send(this.wrapOutputBufferPtr, len);
        this.wrapOutputBuffer.position(0);
    }

    static {
        Field capacityField;
        Field limitField;
        Field addressField;
        BLIND_TRUST_MANAGERS = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String t) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String t) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        LOG = LogFactory.getLog(DelegatingTlsChannel.class);
        try {
            addressField = Buffer.class.getDeclaredField("address");
            limitField = Buffer.class.getDeclaredField("limit");
            capacityField = Buffer.class.getDeclaredField("capacity");
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        ADDRESS_FIELD_OFFSET = Unsafe.getUnsafe().objectFieldOffset(addressField);
        LIMIT_FIELD_OFFSET = Unsafe.getUnsafe().objectFieldOffset(limitField);
        CAPACITY_FIELD_OFFSET = Unsafe.getUnsafe().objectFieldOffset(capacityField);
    }
}

