/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.FactoryProvider;
import io.questdb.Metrics;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.sql.NetworkSqlExecutionCircuitBreaker;
import io.questdb.cutlass.auth.SocketAuthenticator;
import io.questdb.cutlass.pgwire.PGCircuitBreakerRegistry;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.pgwire.PGConnectionContext;
import io.questdb.cutlass.pgwire.PGMessageProcessingException;
import io.questdb.cutlass.pgwire.TypesAndSelect;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IOContextFactoryImpl;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.PeerIsSlowToWriteException;
import io.questdb.network.QueryPausedException;
import io.questdb.std.AssociativeCache;
import io.questdb.std.ConcurrentAssociativeCache;
import io.questdb.std.Misc;
import io.questdb.std.NoOpAssociativeCache;
import io.questdb.std.ObjectFactory;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class PGServer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PGServer.class);
    private static final NoOpAssociativeCache<TypesAndSelect> NO_OP_CACHE = new NoOpAssociativeCache();
    private final PGConnectionContextFactory contextFactory;
    private final IODispatcher<PGConnectionContext> dispatcher;
    private final Metrics metrics;
    private final PGCircuitBreakerRegistry registry;
    private final AssociativeCache<TypesAndSelect> typesAndSelectCache;
    private final WorkerPool sharedPoolNetwork;

    public PGServer(PGConfiguration configuration, CairoEngine engine, WorkerPool sharedPoolNetwork, PGCircuitBreakerRegistry registry, ObjectFactory<SqlExecutionContextImpl> executionContextObjectFactory) {
        this.metrics = engine.getMetrics();
        this.typesAndSelectCache = configuration.isSelectCacheEnabled() ? new ConcurrentAssociativeCache<TypesAndSelect>(configuration.getConcurrentCacheConfiguration()) : NO_OP_CACHE;
        this.contextFactory = new PGConnectionContextFactory(engine, configuration, registry, executionContextObjectFactory, this.typesAndSelectCache);
        this.dispatcher = IODispatchers.create(configuration, this.contextFactory);
        this.sharedPoolNetwork = sharedPoolNetwork;
        this.registry = registry;
        sharedPoolNetwork.assign(this.dispatcher);
        int n = sharedPoolNetwork.getWorkerCount();
        for (int i = 0; i < n; ++i) {
            sharedPoolNetwork.assign(i, new Job(){
                private final IORequestProcessor<PGConnectionContext> processor = (operation, context, dispatcher) -> {
                    try {
                        if (operation == 8) {
                            dispatcher.registerChannel(context, 8);
                            return false;
                        }
                        context.handleClientOperation(operation);
                        dispatcher.registerChannel(context, 1);
                        return true;
                    }
                    catch (PeerIsSlowToWriteException e) {
                        dispatcher.registerChannel(context, 1);
                    }
                    catch (PeerIsSlowToReadException e) {
                        dispatcher.registerChannel(context, 4);
                    }
                    catch (QueryPausedException e) {
                        context.setSuspendEvent(e.getEvent());
                        dispatcher.registerChannel(context, 4);
                    }
                    catch (PeerDisconnectedException e) {
                        dispatcher.disconnect(context, operation == 1 ? 15 : 11);
                    }
                    catch (PGMessageProcessingException e) {
                        LOG.error().$("protocol issue [err: `").$safe(e.getFlyweightMessage()).$("`]").$();
                        dispatcher.disconnect(context, 7);
                    }
                    catch (Throwable e) {
                        LOG.critical().$("internal error [ex=").$(e).$(']').$();
                        PGServer.this.metrics.healthMetrics().incrementUnhandledErrors();
                        dispatcher.disconnect(context, 17);
                    }
                    return false;
                };

                @Override
                public boolean run(int workerId, @NotNull Job.RunStatus runStatus) {
                    return PGServer.this.dispatcher.processIOQueue(this.processor);
                }
            });
            sharedPoolNetwork.assignThreadLocalCleaner(i, this.contextFactory::freeThreadLocal);
        }
    }

    public void clearSelectCache() {
        this.typesAndSelectCache.clear();
    }

    @Override
    public void close() {
        Misc.free(this.dispatcher);
        Misc.free(this.registry);
        Misc.free(this.contextFactory);
        Misc.free(this.typesAndSelectCache);
    }

    public int getPort() {
        return this.dispatcher.getPort();
    }

    public WorkerPool getWorkerPool() {
        return this.sharedPoolNetwork;
    }

    public boolean isListening() {
        return this.dispatcher.isListening();
    }

    public void resetQueryCache() {
        if (this.typesAndSelectCache != null) {
            this.typesAndSelectCache.clear();
        }
    }

    private static class PGConnectionContextFactory
    extends IOContextFactoryImpl<PGConnectionContext> {
        public PGConnectionContextFactory(CairoEngine engine, PGConfiguration configuration, PGCircuitBreakerRegistry registry, ObjectFactory<SqlExecutionContextImpl> executionContextObjectFactory, AssociativeCache<TypesAndSelect> typesAndSelectCache) {
            super(() -> {
                NetworkSqlExecutionCircuitBreaker circuitBreaker = new NetworkSqlExecutionCircuitBreaker(configuration.getCircuitBreakerConfiguration(), 23);
                PGConnectionContext pgConnectionContext = new PGConnectionContext(engine, configuration, (SqlExecutionContextImpl)executionContextObjectFactory.newInstance(), circuitBreaker, typesAndSelectCache);
                FactoryProvider factoryProvider = configuration.getFactoryProvider();
                SocketAuthenticator authenticator = factoryProvider.getPgWireAuthenticatorFactory().getPgWireAuthenticator(configuration, circuitBreaker, registry, pgConnectionContext);
                pgConnectionContext.setAuthenticator(authenticator);
                return pgConnectionContext;
            }, configuration.getConnectionPoolInitialCapacity());
        }
    }
}

