/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SecurityContext;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.text.AbstractTextLexer;
import io.questdb.cutlass.text.TextException;
import io.questdb.cutlass.text.types.BadDateAdapter;
import io.questdb.cutlass.text.types.BadTimestampAdapter;
import io.questdb.cutlass.text.types.OtherToTimestampAdapter;
import io.questdb.cutlass.text.types.TimestampAdapter;
import io.questdb.cutlass.text.types.TimestampCompatibleAdapter;
import io.questdb.cutlass.text.types.TypeAdapter;
import io.questdb.cutlass.text.types.TypeManager;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class CairoTextWriter
implements Closeable,
Mutable {
    public static final int NO_INDEX = -1;
    private static final Log LOG = LogFactory.getLog(CairoTextWriter.class);
    private static final String WRITER_LOCK_REASON = "textWriter";
    private final LongList columnErrorCounts = new LongList();
    private final CairoConfiguration configuration;
    private final MemoryMARW ddlMem = Vm.getCMARWInstance();
    private final CairoEngine engine;
    private final ObjectPool<OtherToTimestampAdapter> otherToTimestampAdapterPool = new ObjectPool<OtherToTimestampAdapter>(OtherToTimestampAdapter::new, 4);
    private final IntList remapIndex = new IntList();
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private int atomicity;
    private boolean create = true;
    private CharSequence designatedTimestampColumnName;
    private int designatedTimestampIndex;
    private CharSequence importedTimestampColumnName;
    private int maxUncommittedRows = -1;
    private RecordMetadata metadata;
    private long o3MaxLag = -1L;
    private boolean overwrite;
    private int partitionBy;
    private CharSequence tableName;
    private TimestampAdapter timestampAdapter;
    private int timestampIndex = -1;
    private ObjList<TypeAdapter> types;
    private int warnings;
    private TableWriterAPI writer;
    private int writtenLineCount;
    private final AbstractTextLexer.Listener partitionedListener = this::onFieldsPartitioned;
    private final AbstractTextLexer.Listener nonPartitionedListener = this::onFieldsNonPartitioned;

    public CairoTextWriter(CairoEngine engine) {
        this.engine = engine;
        this.configuration = engine.getConfiguration();
    }

    @Override
    public void clear() {
        this.otherToTimestampAdapterPool.clear();
        this.writer = Misc.free(this.writer);
        this.metadata = null;
        this.columnErrorCounts.clear();
        this.timestampAdapter = null;
        this.writtenLineCount = 0;
        this.warnings = 0;
        this.designatedTimestampColumnName = null;
        this.designatedTimestampIndex = -1;
        this.timestampIndex = -1;
        this.importedTimestampColumnName = null;
        this.maxUncommittedRows = -1;
        this.o3MaxLag = -1L;
        this.remapIndex.clear();
        this.create = true;
    }

    @Override
    public void close() {
        this.clear();
        this.ddlMem.close();
    }

    public void closeWriter() {
        this.writer = Misc.free(this.writer);
        this.metadata = null;
    }

    public void commit() {
        if (this.writer != null) {
            this.writer.commit();
        }
    }

    public LongList getColumnErrorCounts() {
        return this.columnErrorCounts;
    }

    public boolean getCreate() {
        return this.create;
    }

    public int getMaxUncommittedRows() {
        return this.maxUncommittedRows;
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public long getO3MaxLag() {
        return this.o3MaxLag;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public CharSequence getTableName() {
        return this.tableName;
    }

    public AbstractTextLexer.Listener getTextListener() {
        return this.timestampAdapter != null ? this.partitionedListener : this.nonPartitionedListener;
    }

    public CharSequence getTimestampCol() {
        return this.designatedTimestampColumnName;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public long getWrittenLineCount() {
        return this.writtenLineCount;
    }

    public void of(CharSequence name, boolean overwrite, int atomicity, int partitionBy, CharSequence timestampColumn) {
        this.tableName = name;
        this.overwrite = overwrite;
        this.atomicity = atomicity;
        this.partitionBy = partitionBy;
        this.importedTimestampColumnName = timestampColumn;
    }

    public void onFieldsNonPartitioned(long line, ObjList<DirectUtf8String> values, int valuesLength) {
        TableWriter.Row w = this.writer.newRow();
        for (int i = 0; i < valuesLength; ++i) {
            DirectUtf8String dus = values.getQuick(i);
            if (dus.size() == 0 || !this.onField(line, dus, w, i)) continue;
            return;
        }
        w.append();
        ++this.writtenLineCount;
    }

    public void onFieldsPartitioned(long line, ObjList<DirectUtf8String> values, int valuesLength) {
        int timestampIndex = this.timestampIndex;
        DirectUtf8String dus = values.getQuick(timestampIndex);
        try {
            TableWriter.Row w = this.writer.newRow(this.timestampAdapter.getTimestamp(dus));
            for (int i = 0; i < valuesLength; ++i) {
                dus = values.getQuick(i);
                if (i == timestampIndex || dus.size() == 0 || !this.onField(line, dus, w, i)) continue;
                return;
            }
            w.append();
            ++this.writtenLineCount;
            this.checkUncommittedRowCount();
        }
        catch (Exception e) {
            this.logError(line, timestampIndex, dus);
        }
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setMaxUncommittedRows(int maxUncommittedRows) {
        this.maxUncommittedRows = maxUncommittedRows;
    }

    public void setO3MaxLag(long o3MaxLag) {
        this.o3MaxLag = o3MaxLag;
    }

    private void checkUncommittedRowCount() {
        if (this.writer != null && this.maxUncommittedRows > 0 && this.writer.getUncommittedRowCount() >= (long)this.maxUncommittedRows) {
            this.writer.ic(this.o3MaxLag);
        }
    }

    private TableToken createTable(ObjList<CharSequence> names, ObjList<TypeAdapter> detectedTypes, SecurityContext securityContext, Path path) throws TextException {
        TableToken tableToken = this.engine.createTable(securityContext, this.ddlMem, path, false, this.tableStructureAdapter.of(names, detectedTypes), false);
        this.types = detectedTypes;
        return tableToken;
    }

    private CharSequence getDesignatedTimestampColumnName(RecordMetadata metadata) {
        return metadata.getTimestampIndex() > -1 ? metadata.getColumnName(metadata.getTimestampIndex()) : null;
    }

    private void initWriterAndOverrideImportTypes(TableToken tableToken, ObjList<CharSequence> names, ObjList<TypeAdapter> detectedTypes, TypeManager typeManager) {
        TableWriterAPI writer = this.engine.getTableWriterAPI(tableToken, WRITER_LOCK_REASON);
        GenericRecordMetadata metadata = GenericRecordMetadata.copyDense(writer.getMetadata());
        if (metadata.getColumnCount() < detectedTypes.size()) {
            writer.close();
            throw CairoException.nonCritical().put("column count mismatch [textColumnCount=").put(detectedTypes.size()).put(", tableColumnCount=").put(metadata.getColumnCount()).put(", table=").put(this.tableName).put(']');
        }
        this.types = detectedTypes;
        this.remapIndex.setPos(this.types.size());
        int n = this.types.size();
        block5: for (int i = 0; i < n; ++i) {
            int columnIndex = metadata.getColumnIndexQuiet(names.getQuick(i));
            int idx = columnIndex > -1 ? columnIndex : i;
            this.remapIndex.set(i, metadata.getWriterIndex(idx));
            int columnType = metadata.getColumnType(idx);
            TypeAdapter detectedAdapter = this.types.getQuick(i);
            int detectedType = detectedAdapter.getType();
            if (detectedType == columnType) continue;
            switch (ColumnType.tagOf(columnType)) {
                case 7: {
                    this.logTypeError(i);
                    this.types.setQuick(i, BadDateAdapter.INSTANCE);
                    continue block5;
                }
                case 8: {
                    if (detectedAdapter instanceof TimestampCompatibleAdapter) {
                        this.types.setQuick(i, this.otherToTimestampAdapterPool.next().of((TimestampCompatibleAdapter)detectedAdapter));
                        continue block5;
                    }
                    this.logTypeError(i);
                    this.types.setQuick(i, BadTimestampAdapter.INSTANCE);
                    continue block5;
                }
                case 18: {
                    writer.close();
                    throw CairoException.nonCritical().put("cannot import text into BINARY column [index=").put(i).put(']');
                }
                default: {
                    this.types.setQuick(i, typeManager.getTypeAdapter(columnType));
                }
            }
        }
        this.writer = writer;
        this.metadata = metadata;
    }

    private void logError(long line, int i, DirectUtf8Sequence dus) {
        LogRecord logRecord = LOG.error().$("type syntax [type=").$(ColumnType.nameOf(this.types.getQuick(i).getType())).$("]\n\t");
        logRecord.$('[').$(line).$(':').$(i).$("] -> ").$(dus).$();
        this.columnErrorCounts.increment(i);
    }

    private void logTypeError(int i) {
        LOG.info().$("mis-detected [table=").$safe(this.tableName).$(", column=").$(i).$(", type=").$(ColumnType.nameOf(this.types.getQuick(i).getType())).$(']').$();
    }

    private boolean onField(long line, DirectUtf8Sequence dus, TableWriter.Row w, int i) {
        try {
            int tableIndex = this.remapIndex.size() > 0 ? this.remapIndex.get(i) : i;
            this.types.getQuick(i).write(w, tableIndex, dus);
        }
        catch (Exception ignore) {
            this.logError(line, i, dus);
            switch (this.atomicity) {
                case 0: {
                    w.cancel();
                    this.writer.rollback();
                    throw CairoException.nonCritical().put("bad syntax [line=").put(line).put(", col=").put(i).put(']');
                }
                case 1: {
                    w.cancel();
                    return true;
                }
            }
        }
        return false;
    }

    void prepareTable(SecurityContext securityContext, ObjList<CharSequence> names, ObjList<TypeAdapter> detectedTypes, Path path, TypeManager typeManager, TimestampAdapter timestampAdapter) throws TextException {
        assert (this.writer == null);
        if (detectedTypes.size() == 0) {
            throw CairoException.nonCritical().put("cannot determine text structure");
        }
        boolean tableReCreated = false;
        switch (this.engine.getTableStatus(path, this.tableName)) {
            case 1: {
                if (!this.create) {
                    throw CairoException.tableDoesNotExist(this.tableName).put(" and create param was set to false.");
                }
                TableToken tableToken = this.createTable(names, detectedTypes, securityContext, path);
                tableReCreated = true;
                this.writer = this.engine.getTableWriterAPI(tableToken, WRITER_LOCK_REASON);
                this.metadata = GenericRecordMetadata.copyDense(this.writer.getMetadata());
                this.designatedTimestampColumnName = this.getDesignatedTimestampColumnName(this.metadata);
                this.designatedTimestampIndex = this.writer.getMetadata().getTimestampIndex();
                break;
            }
            case 0: {
                TableToken tableToken = this.engine.getTableTokenIfExists(this.tableName);
                if (tableToken != null && tableToken.isMatView()) {
                    throw CairoException.nonCritical().put("cannot modify materialized view [view=").put(tableToken.getTableName()).put(']');
                }
                if (this.overwrite) {
                    securityContext.authorizeTableDrop(tableToken);
                    this.engine.dropTableOrMatView(path, tableToken);
                    tableToken = this.createTable(names, detectedTypes, securityContext, path);
                    tableReCreated = true;
                    this.writer = this.engine.getTableWriterAPI(tableToken, WRITER_LOCK_REASON);
                    this.metadata = GenericRecordMetadata.copyDense(this.writer.getMetadata());
                    break;
                }
                this.initWriterAndOverrideImportTypes(tableToken, names, detectedTypes, typeManager);
                this.designatedTimestampIndex = this.writer.getMetadata().getTimestampIndex();
                this.designatedTimestampColumnName = this.getDesignatedTimestampColumnName(this.writer.getMetadata());
                if (this.importedTimestampColumnName != null && !Chars.equalsNc(this.importedTimestampColumnName, this.designatedTimestampColumnName)) {
                    this.warnings |= 1;
                }
                int tablePartitionBy = TableUtils.getPartitionBy(this.writer.getMetadata(), this.engine);
                if (PartitionBy.isPartitioned(this.partitionBy) && this.partitionBy != tablePartitionBy) {
                    this.warnings |= 2;
                }
                this.partitionBy = tablePartitionBy;
                this.tableStructureAdapter.of(names, detectedTypes);
                securityContext.authorizeInsert(tableToken);
                break;
            }
            default: {
                throw CairoException.nonCritical().put("name is reserved [table=").put(this.tableName).put(']');
            }
        }
        if (!(tableReCreated || this.o3MaxLag <= -1L && this.maxUncommittedRows <= -1)) {
            LOG.info().$("cannot update metadata attributes o3MaxLag and maxUncommittedRows when the table exists and parameter overwrite is false").$();
        }
        if (PartitionBy.isPartitioned(this.partitionBy)) {
            if (this.o3MaxLag == -1L && !this.writer.getMetadata().isWalEnabled()) {
                this.o3MaxLag = TableUtils.getO3MaxLag(this.writer.getMetadata(), this.engine);
                LOG.info().$("using table's o3MaxLag ").$(this.o3MaxLag).$(", table=").$safe(this.tableName).$();
            }
            if (this.maxUncommittedRows == -1) {
                this.maxUncommittedRows = TableUtils.getMaxUncommittedRows(this.writer.getMetadata(), this.engine);
                LOG.info().$("using table's maxUncommittedRows ").$(this.maxUncommittedRows).$(", table=").$safe(this.tableName).$();
            }
        }
        this.columnErrorCounts.seed(this.writer.getMetadata().getColumnCount(), 0L);
        if (this.timestampIndex != -1) {
            if (timestampAdapter != null) {
                this.timestampAdapter = timestampAdapter;
            } else if (ColumnType.isTimestamp(this.types.getQuick(this.timestampIndex).getType())) {
                this.timestampAdapter = (TimestampAdapter)this.types.getQuick(this.timestampIndex);
            }
        }
    }

    private class TableStructureAdapter
    implements TableStructure {
        private ObjList<CharSequence> names;
        private ObjList<TypeAdapter> types;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.types.size();
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            return this.names.getQuick(columnIndex);
        }

        @Override
        public int getColumnType(int columnIndex) {
            return this.types.getQuick(columnIndex).getType();
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return CairoTextWriter.this.configuration.getIndexValueBlockSize();
        }

        @Override
        public int getMaxUncommittedRows() {
            return CairoTextWriter.this.maxUncommittedRows > -1 && PartitionBy.isPartitioned(CairoTextWriter.this.partitionBy) ? CairoTextWriter.this.maxUncommittedRows : CairoTextWriter.this.configuration.getMaxUncommittedRows();
        }

        @Override
        public long getO3MaxLag() {
            return CairoTextWriter.this.o3MaxLag > -1L && PartitionBy.isPartitioned(CairoTextWriter.this.partitionBy) ? CairoTextWriter.this.o3MaxLag : CairoTextWriter.this.configuration.getO3MaxLag();
        }

        @Override
        public int getPartitionBy() {
            return CairoTextWriter.this.partitionBy;
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            return CairoTextWriter.this.configuration.getDefaultSymbolCacheFlag();
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            return CairoTextWriter.this.configuration.getDefaultSymbolCapacity();
        }

        @Override
        public CharSequence getTableName() {
            return CairoTextWriter.this.tableName;
        }

        @Override
        public int getTimestampIndex() {
            return CairoTextWriter.this.timestampIndex;
        }

        @Override
        public boolean isDedupKey(int columnIndex) {
            return false;
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return this.types.getQuick(columnIndex).isIndexed();
        }

        @Override
        public boolean isWalEnabled() {
            return CairoTextWriter.this.configuration.getWalEnabledDefault() && PartitionBy.isPartitioned(CairoTextWriter.this.partitionBy);
        }

        TableStructureAdapter of(ObjList<CharSequence> names, ObjList<TypeAdapter> types) throws TextException {
            TypeAdapter timestampAdapter;
            short typeTag;
            this.names = names;
            this.types = types;
            if (CairoTextWriter.this.importedTimestampColumnName == null && CairoTextWriter.this.designatedTimestampColumnName == null) {
                CairoTextWriter.this.timestampIndex = -1;
            } else if (CairoTextWriter.this.importedTimestampColumnName != null) {
                CairoTextWriter.this.timestampIndex = names.indexOf(CairoTextWriter.this.importedTimestampColumnName);
                if (CairoTextWriter.this.timestampIndex == -1) {
                    throw TextException.$("invalid timestamp column '").put(CairoTextWriter.this.importedTimestampColumnName).put('\'');
                }
            } else {
                CairoTextWriter.this.timestampIndex = names.indexOf(CairoTextWriter.this.designatedTimestampColumnName);
                if (CairoTextWriter.this.timestampIndex == -1) {
                    CairoTextWriter.this.timestampIndex = CairoTextWriter.this.designatedTimestampIndex;
                }
            }
            if (CairoTextWriter.this.timestampIndex != -1 && ((typeTag = ColumnType.tagOf((timestampAdapter = types.getQuick(CairoTextWriter.this.timestampIndex)).getType())) != 6 && typeTag != 8 || timestampAdapter == BadTimestampAdapter.INSTANCE)) {
                throw TextException.$("not a timestamp '").put(CairoTextWriter.this.importedTimestampColumnName).put('\'');
            }
            return this;
        }
    }
}

