/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;

public interface QuaternaryFunction
extends Function {
    @Override
    default public void close() {
        this.getFunc0().close();
        this.getFunc1().close();
        this.getFunc2().close();
        this.getFunc3().close();
    }

    @Override
    default public void cursorClosed() {
        this.getFunc0().cursorClosed();
        this.getFunc1().cursorClosed();
        this.getFunc2().cursorClosed();
        this.getFunc3().cursorClosed();
    }

    public Function getFunc0();

    public Function getFunc1();

    public Function getFunc2();

    public Function getFunc3();

    @Override
    default public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.getFunc0().init(symbolTableSource, executionContext);
        this.getFunc1().init(symbolTableSource, executionContext);
        this.getFunc2().init(symbolTableSource, executionContext);
        this.getFunc3().init(symbolTableSource, executionContext);
    }

    @Override
    default public boolean isConstant() {
        return this.getFunc0().isConstant() && this.getFunc1().isConstant() && this.getFunc2().isConstant() && this.getFunc3().isConstant();
    }

    @Override
    default public boolean isNonDeterministic() {
        return this.getFunc0().isNonDeterministic() || this.getFunc1().isNonDeterministic() || this.getFunc2().isNonDeterministic() || this.getFunc3().isNonDeterministic();
    }

    @Override
    default public boolean isRandom() {
        return this.getFunc0().isRandom() || this.getFunc1().isRandom() || this.getFunc2().isRandom() || this.getFunc3().isRandom();
    }

    @Override
    default public boolean isRuntimeConstant() {
        boolean arc = this.getFunc0().isRuntimeConstant();
        boolean brc = this.getFunc1().isRuntimeConstant();
        boolean crc = this.getFunc2().isRuntimeConstant();
        boolean drc = this.getFunc3().isRuntimeConstant();
        boolean ac = this.getFunc0().isConstant();
        boolean bc = this.getFunc1().isConstant();
        boolean cc = this.getFunc2().isConstant();
        boolean dc = this.getFunc3().isConstant();
        return !(!ac && !arc || !bc && !brc || !cc && !crc || !dc && !drc || !arc && !brc && !crc && !drc);
    }

    @Override
    default public boolean isThreadSafe() {
        return this.getFunc0().isThreadSafe() && this.getFunc1().isThreadSafe() && this.getFunc2().isThreadSafe() && this.getFunc3().isThreadSafe();
    }

    @Override
    default public void memoize(Record record) {
        this.getFunc0().memoize(record);
        this.getFunc1().memoize(record);
        this.getFunc2().memoize(record);
        this.getFunc3().memoize(record);
    }

    @Override
    default public void offerStateTo(Function that) {
        if (that instanceof QuaternaryFunction) {
            this.getFunc0().offerStateTo(((QuaternaryFunction)that).getFunc0());
            this.getFunc1().offerStateTo(((QuaternaryFunction)that).getFunc1());
            this.getFunc2().offerStateTo(((QuaternaryFunction)that).getFunc2());
            this.getFunc3().offerStateTo(((QuaternaryFunction)that).getFunc3());
        }
    }

    @Override
    default public boolean shouldMemoize() {
        return this.getFunc0().shouldMemoize() || this.getFunc1().shouldMemoize() || this.getFunc2().shouldMemoize() || this.getFunc3().shouldMemoize();
    }

    @Override
    default public boolean supportsParallelism() {
        return this.getFunc0().supportsParallelism() && this.getFunc1().supportsParallelism() && this.getFunc2().supportsParallelism() && this.getFunc3().supportsParallelism();
    }

    @Override
    default public boolean supportsRandomAccess() {
        return this.getFunc0().supportsRandomAccess() && this.getFunc1().supportsRandomAccess() && this.getFunc2().supportsRandomAccess() && this.getFunc3().supportsRandomAccess();
    }

    @Override
    default public void toPlan(PlanSink sink) {
        sink.val(this.getName()).val('(').val(this.getFunc0()).val(',').val(this.getFunc1()).val(',').val(this.getFunc2()).val(',').val(this.getFunc3()).val(')');
    }

    @Override
    default public void toTop() {
        this.getFunc0().toTop();
        this.getFunc1().toTop();
        this.getFunc2().toTop();
        this.getFunc3().toTop();
    }
}

