/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;

public class StrBindVariable
extends StrFunction
implements Mutable {
    private final StringSink utf16Sink = new StringSink();
    private final Utf8StringSink utf8Sink = new Utf8StringSink();
    private boolean isNull = true;

    @Override
    public void clear() {
        this.isNull = true;
        this.utf16Sink.clear();
        this.utf8Sink.clear();
    }

    @Override
    public CharSequence getStrA(Record rec) {
        return this.isNull ? null : this.utf16Sink;
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.isNull ? null : this.utf16Sink;
    }

    @Override
    public int getStrLen(Record rec) {
        if (this.isNull) {
            return -1;
        }
        return this.utf16Sink.length();
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        return this.isNull ? null : this.utf8Sink;
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        return this.isNull ? null : this.utf8Sink;
    }

    @Override
    public int getVarcharSize(Record rec) {
        if (this.isNull) {
            return -1;
        }
        return this.utf8Sink.size();
    }

    @Override
    public boolean isNonDeterministic() {
        return true;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    public void setTimestamp(long value) {
        boolean bl = this.isNull = value == Long.MIN_VALUE;
        if (!this.isNull) {
            this.utf16Sink.clear();
            TimestampFormatUtils.appendDateTimeUSec(this.utf16Sink, value);
            this.utf8Sink.clear();
            TimestampFormatUtils.appendDateTimeUSec(this.utf8Sink, value);
        }
    }

    public void setUuidValue(long lo, long hi) {
        this.utf16Sink.clear();
        if (SqlUtil.implicitCastUuidAsStr(lo, hi, this.utf16Sink)) {
            this.utf8Sink.clear();
            Numbers.appendUuid(lo, hi, this.utf8Sink);
            this.isNull = false;
        }
    }

    public void setValue(boolean value) {
        this.isNull = false;
        this.utf16Sink.clear();
        this.utf16Sink.put(value);
        this.utf8Sink.clear();
        this.utf8Sink.put(value);
    }

    public void setValue(char value) {
        this.isNull = false;
        this.utf16Sink.clear();
        this.utf16Sink.put(value);
        this.utf8Sink.clear();
        this.utf8Sink.put(value);
    }

    public void setValue(long l0, long l1, long l2, long l3) {
        this.isNull = false;
        this.utf16Sink.clear();
        Numbers.appendLong256(l0, l1, l2, l3, this.utf16Sink);
        this.utf8Sink.clear();
        Numbers.appendLong256(l0, l1, l2, l3, this.utf8Sink);
    }

    public void setValue(short value) {
        this.isNull = false;
        this.utf16Sink.clear();
        this.utf16Sink.put(value);
        this.utf8Sink.clear();
        this.utf8Sink.put(value);
    }

    public void setValue(byte value) {
        this.isNull = false;
        this.utf16Sink.clear();
        this.utf16Sink.put(value);
        this.utf8Sink.clear();
        this.utf8Sink.put((int)value);
    }

    public void setValue(long value) {
        boolean bl = this.isNull = value == Long.MIN_VALUE;
        if (!this.isNull) {
            this.utf16Sink.clear();
            this.utf16Sink.put(value);
            this.utf8Sink.clear();
            this.utf8Sink.put(value);
        }
    }

    public void setValue(int value) {
        boolean bl = this.isNull = value == Integer.MIN_VALUE;
        if (!this.isNull) {
            this.utf16Sink.clear();
            this.utf16Sink.put(value);
            this.utf8Sink.clear();
            this.utf8Sink.put(value);
        }
    }

    public void setValue(double value) {
        this.isNull = Numbers.isNull(value);
        if (!this.isNull) {
            this.utf16Sink.clear();
            this.utf16Sink.put(value);
            this.utf8Sink.clear();
            this.utf8Sink.put(value);
        }
    }

    public void setValue(float value) {
        this.isNull = Numbers.isNull(value);
        if (!this.isNull) {
            this.utf16Sink.clear();
            this.utf16Sink.put(value);
            this.utf8Sink.clear();
            this.utf8Sink.put(value);
        }
    }

    public void setValue(CharSequence value) {
        if (value == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            this.utf16Sink.clear();
            this.utf16Sink.put(value);
            this.utf8Sink.clear();
            this.utf8Sink.put(value);
        }
    }

    public void setValue(Utf8Sequence value) {
        if (value == null) {
            this.isNull = true;
        } else {
            this.isNull = false;
            this.utf16Sink.clear();
            this.utf16Sink.put(value);
            this.utf8Sink.clear();
            this.utf8Sink.put(value);
        }
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("?::string");
    }
}

