/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class InLongFunctionFactory
implements FunctionFactory {
    public static long tryParseLong(CharSequence seq, int position) throws SqlException {
        try {
            return Numbers.parseLong(seq, 0, seq.length());
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("invalid LONG value [").put(seq).put(']');
        }
    }

    @Override
    public String getSignature() {
        return "in(LV)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int constCount = 0;
        int runtimeConstCount = 0;
        int argCount = args.size() - 1;
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 0: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 11: 
                case 12: 
                case 26: 
                case 33: {
                    break;
                }
                default: {
                    throw SqlException.position(argPositions.get(i)).put("cannot compare LONG with type ").put(ColumnType.nameOf(func.getType()));
                }
            }
            if (func.isConstant()) {
                ++constCount;
            }
            if (!func.isRuntimeConstant()) continue;
            ++runtimeConstCount;
        }
        if (constCount == argCount) {
            LongList inVals = new LongList(args.size() - 1);
            InLongFunctionFactory.parseToLong(args, argPositions, inVals);
            if (inVals.size() == 0) {
                return new InLongSingleConstFunction(args.getQuick(0), inVals.getQuick(0));
            }
            if (inVals.size() == 2) {
                return new InLongTwoConstFunction(args.getQuick(0), inVals.getQuick(0), inVals.getQuick(1));
            }
            return new InLongConstFunction(args.getQuick(0), inVals);
        }
        if (runtimeConstCount == argCount || runtimeConstCount + constCount == argCount) {
            IntList positions = new IntList();
            positions.addAll(argPositions);
            return new InLongRuntimeConstFunction(args.getQuick(0), new ObjList<Function>(args), positions);
        }
        return new InLongVarFunction(new ObjList<Function>(args));
    }

    private static void parseToLong(ObjList<Function> args, IntList argPositions, LongList outLongList) throws SqlException {
        int n = args.size();
        for (int i = 1; i < n; ++i) {
            outLongList.add(InLongFunctionFactory.parseValue(argPositions, args.getQuick(i), i));
        }
        outLongList.sort();
    }

    private static long parseValue(IntList argPositions, Function func, int i) throws SqlException {
        long val;
        switch (ColumnType.tagOf(func.getType())) {
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                val = func.getLong(null);
                break;
            }
            case 11: 
            case 12: 
            case 33: {
                CharSequence tsValue = func.getStrA(null);
                val = tsValue != null ? InLongFunctionFactory.tryParseLong(tsValue, argPositions.getQuick(i)) : Long.MIN_VALUE;
                break;
            }
            case 26: {
                Utf8Sequence seq = func.getVarcharA(null);
                val = seq != null ? InLongFunctionFactory.tryParseLong(seq.asAsciiCharSequence(), argPositions.getQuick(i)) : Long.MIN_VALUE;
                break;
            }
            default: {
                throw SqlException.inconvertibleTypes(argPositions.getQuick(i), func.getType(), ColumnType.nameOf(func.getType()), 6, ColumnType.nameOf(6));
            }
        }
        return val;
    }

    private static class InLongSingleConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final long inVal;
        private final Function longFunc;

        public InLongSingleConstFunction(Function longFunc, long inVal) {
            this.longFunc = longFunc;
            this.inVal = inVal;
        }

        @Override
        public Function getArg() {
            return this.longFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            long val = this.longFunc.getLong(rec);
            return this.negated != (val == this.inVal);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.longFunc);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in [").val(this.inVal).val(']');
        }
    }

    private static class InLongTwoConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final long inVal0;
        private final long inVal1;
        private final Function longFunc;

        public InLongTwoConstFunction(Function longFunc, long inVal0, long inVal1) {
            this.longFunc = longFunc;
            this.inVal0 = inVal0;
            this.inVal1 = inVal1;
        }

        @Override
        public Function getArg() {
            return this.longFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            long val = this.longFunc.getLong(rec);
            return this.negated != (val == this.inVal0 || val == this.inVal1);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.longFunc);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in [").val(this.inVal0).val(',').val(this.inVal1).val(']');
        }
    }

    private static class InLongConstFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final LongList inList;
        private final Function tsFunc;

        public InLongConstFunction(Function tsFunc, LongList longList) {
            this.tsFunc = tsFunc;
            this.inList = longList;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            long val = this.tsFunc.getLong(rec);
            return this.negated != this.inList.binarySearch(val, -1) >= 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.tsFunc);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }

    private static class InLongRuntimeConstFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final LongList inList;
        private final Function keyFunc;
        private final IntList valueFunctionPositions;
        private final ObjList<Function> valueFunctions;

        public InLongRuntimeConstFunction(Function keyFunc, ObjList<Function> valueFunctions, IntList valueFunctionPositions) {
            this.keyFunc = keyFunc;
            this.valueFunctions = valueFunctions;
            this.valueFunctionPositions = valueFunctionPositions;
            this.inList = new LongList(valueFunctions.size() - 1);
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.valueFunctions;
        }

        @Override
        public boolean getBool(Record rec) {
            long val = this.keyFunc.getLong(rec);
            return this.negated != this.inList.binarySearch(val, -1) >= 0;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            MultiArgFunction.super.init(symbolTableSource, executionContext);
            this.inList.clear();
            InLongFunctionFactory.parseToLong(this.valueFunctions, this.valueFunctionPositions, this.inList);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.keyFunc);
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ").val(this.inList);
        }
    }

    private static class InLongVarFunction
    extends NegatableBooleanFunction
    implements MultiArgFunction {
        private final ObjList<Function> args;

        public InLongVarFunction(ObjList<Function> args) {
            this.args = args;
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.args;
        }

        @Override
        public boolean getBool(Record rec) {
            long val = this.args.getQuick(0).getLong(rec);
            int n = this.args.size();
            for (int i = 1; i < n; ++i) {
                Function func = this.args.getQuick(i);
                long inVal = Long.MIN_VALUE;
                switch (ColumnType.tagOf(func.getType())) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: {
                        inVal = func.getLong(rec);
                        break;
                    }
                    case 11: 
                    case 12: {
                        CharSequence str = func.getStrA(rec);
                        inVal = Numbers.parseLongQuiet(str);
                        break;
                    }
                    case 26: {
                        Utf8Sequence seq = func.getVarcharA(rec);
                        CharSequence cs = seq == null ? null : seq.asAsciiCharSequence();
                        inVal = Numbers.parseLongQuiet(cs);
                    }
                }
                if (inVal != val) continue;
                return !this.negated;
            }
            return this.negated;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.args.getQuick(0));
            if (this.negated) {
                sink.val(" not");
            }
            sink.val(" in ");
            sink.val(this.args, 1);
        }
    }
}

