/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastIntervalToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u0394s)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function intervalFunc = args.getQuick(0);
        if (intervalFunc.isConstant()) {
            StringSink sink = Misc.getThreadLocalSink();
            Interval interval = intervalFunc.getInterval(null);
            if (Interval.NULL.equals(interval)) {
                return StrConstant.NULL;
            }
            interval.toSink(sink);
            return new StrConstant(Chars.toString(sink));
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToStrFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStrA(Record rec) {
            Interval value = this.arg.getInterval(rec);
            if (!Interval.NULL.equals(value)) {
                this.sinkA.clear();
                value.toSink(this.sinkA);
                return this.sinkA;
            }
            return null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            Interval value = this.arg.getInterval(rec);
            if (!Interval.NULL.equals(value)) {
                this.sinkB.clear();
                value.toSink(this.sinkB);
                return this.sinkB;
            }
            return null;
        }
    }
}

