/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class TablesFunctionFactory
implements FunctionFactory {
    private static final int DEDUP_NAME_COLUMN = 8;
    private static final int DESIGNATED_TIMESTAMP_COLUMN = 2;
    private static final int DIRECTORY_NAME_COLUMN = 7;
    private static final int ID_COLUMN = 0;
    private static final int IS_MAT_VIEW_COLUMN = 11;
    private static final int MAX_UNCOMMITTED_ROWS_COLUMN = 4;
    private static final RecordMetadata METADATA;
    private static final int O3_MAX_LAG_COLUMN = 5;
    private static final int PARTITION_BY_COLUMN = 3;
    private static final int TABLE_NAME = 1;
    private static final int TTL_UNIT_COLUMN = 10;
    private static final int TTL_VALUE_COLUMN = 9;
    private static final int WAL_ENABLED_COLUMN = 6;

    public static String getTtlUnit(int ttl) {
        if (ttl == 0) {
            return "HOUR";
        }
        if (ttl < 0) {
            return -ttl % 12 != 0 ? "MONTH" : "YEAR";
        }
        if (ttl % 24 != 0) {
            return "HOUR";
        }
        return (ttl /= 24) % 7 != 0 ? "DAY" : "WEEK";
    }

    public static int getTtlValue(int ttl) {
        if (ttl == 0) {
            return 0;
        }
        if (ttl > 0) {
            if (ttl % 24 != 0) {
                return ttl;
            }
            return (ttl /= 24) % 7 == 0 ? ttl / 7 : ttl;
        }
        return (ttl = -ttl) % 12 == 0 ? ttl / 12 : ttl;
    }

    @Override
    public String getSignature() {
        return "tables()";
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new TablesCursorFactory()){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("id", 5));
        metadata.add(new TableColumnMetadata("table_name", 11));
        metadata.add(new TableColumnMetadata("designatedTimestamp", 11));
        metadata.add(new TableColumnMetadata("partitionBy", 11));
        metadata.add(new TableColumnMetadata("maxUncommittedRows", 5));
        metadata.add(new TableColumnMetadata("o3MaxLag", 6));
        metadata.add(new TableColumnMetadata("walEnabled", 1));
        metadata.add(new TableColumnMetadata("directoryName", 11));
        metadata.add(new TableColumnMetadata("dedup", 1));
        metadata.add(new TableColumnMetadata("ttlValue", 5));
        metadata.add(new TableColumnMetadata("ttlUnit", 11));
        metadata.add(new TableColumnMetadata("matView", 1));
        METADATA = metadata;
    }

    public static class TablesCursorFactory
    extends AbstractRecordCursorFactory {
        public static final Log LOG = LogFactory.getLog(TablesCursorFactory.class);
        private final TablesRecordCursor cursor;
        private final CharSequenceObjHashMap<CairoTable> tableCache = new CharSequenceObjHashMap();
        private long tableCacheVersion = -1L;

        public TablesCursorFactory() {
            super(METADATA);
            this.cursor = new TablesRecordCursor(this.tableCache);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            CairoEngine engine = executionContext.getCairoEngine();
            try (MetadataCacheReader metadataRO = engine.getMetadataCache().readLock();){
                this.tableCacheVersion = metadataRO.snapshot(this.tableCache, this.tableCacheVersion);
            }
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("tables()");
        }

        @Override
        protected void _close() {
            this.cursor.close();
        }

        private static class TablesRecordCursor
        implements NoRandomAccessRecordCursor {
            private final TableListRecord record = new TableListRecord();
            private final CharSequenceObjHashMap<CairoTable> tableCache;
            private int iteratorIdx = -1;

            public TablesRecordCursor(CharSequenceObjHashMap<CairoTable> tableCache) {
                this.tableCache = tableCache;
            }

            @Override
            public void close() {
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                if (this.iteratorIdx < this.tableCache.size() - 1) {
                    this.record.of(this.tableCache.getAt(++this.iteratorIdx));
                    return true;
                }
                return false;
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public void toTop() {
                this.iteratorIdx = -1;
            }

            private static class TableListRecord
            implements Record {
                private StringSink lazyStringSink = null;
                private CairoTable table;

                private TableListRecord() {
                }

                @Override
                public boolean getBool(int col) {
                    switch (col) {
                        case 6: {
                            return this.table.isWalEnabled();
                        }
                        case 8: {
                            return this.table.hasDedup();
                        }
                        case 11: {
                            return this.table.getTableToken().isMatView();
                        }
                    }
                    return false;
                }

                @Override
                public int getInt(int col) {
                    if (col == 0) {
                        return this.table.getId();
                    }
                    if (col == 9) {
                        return TablesFunctionFactory.getTtlValue(this.table.getTtlHoursOrMonths());
                    }
                    assert (col == 4);
                    return this.table.getMaxUncommittedRows();
                }

                @Override
                public long getLong(int col) {
                    assert (col == 5);
                    return this.table.getO3MaxLag();
                }

                @Override
                public CharSequence getStrA(int col) {
                    switch (col) {
                        case 1: {
                            return this.table.getTableName();
                        }
                        case 3: {
                            return this.table.getPartitionByName();
                        }
                        case 10: {
                            return TablesFunctionFactory.getTtlUnit(this.table.getTtlHoursOrMonths());
                        }
                        case 2: {
                            return this.table.getTimestampName();
                        }
                        case 7: {
                            if (this.table.isSoftLink()) {
                                if (this.lazyStringSink == null) {
                                    this.lazyStringSink = new StringSink();
                                }
                                this.lazyStringSink.clear();
                                this.lazyStringSink.put(this.table.getDirectoryName()).put(" (->)");
                                return this.lazyStringSink;
                            }
                            return this.table.getDirectoryName();
                        }
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return TableUtils.lengthOf(this.getStrA(col));
                }

                private void of(CairoTable table) {
                    this.table = table;
                }
            }
        }
    }
}

