/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.ColumnType;
import io.questdb.griffin.TypeConstant;
import io.questdb.griffin.engine.functions.constants.ArrayTypeConstant;
import io.questdb.griffin.engine.functions.constants.BinTypeConstant;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.constants.BooleanTypeConstant;
import io.questdb.griffin.engine.functions.constants.ByteConstant;
import io.questdb.griffin.engine.functions.constants.ByteTypeConstant;
import io.questdb.griffin.engine.functions.constants.CharConstant;
import io.questdb.griffin.engine.functions.constants.CharTypeConstant;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.griffin.engine.functions.constants.DateConstant;
import io.questdb.griffin.engine.functions.constants.DateTypeConstant;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.griffin.engine.functions.constants.DoubleTypeConstant;
import io.questdb.griffin.engine.functions.constants.FloatConstant;
import io.questdb.griffin.engine.functions.constants.FloatTypeConstant;
import io.questdb.griffin.engine.functions.constants.GeoByteConstant;
import io.questdb.griffin.engine.functions.constants.GeoIntConstant;
import io.questdb.griffin.engine.functions.constants.GeoLongConstant;
import io.questdb.griffin.engine.functions.constants.GeoShortConstant;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.griffin.engine.functions.constants.IPv4TypeConstant;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.griffin.engine.functions.constants.IntTypeConstant;
import io.questdb.griffin.engine.functions.constants.IntervalConstant;
import io.questdb.griffin.engine.functions.constants.IntervalTypeConstant;
import io.questdb.griffin.engine.functions.constants.Long128Constant;
import io.questdb.griffin.engine.functions.constants.Long256NullConstant;
import io.questdb.griffin.engine.functions.constants.Long256TypeConstant;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.griffin.engine.functions.constants.LongTypeConstant;
import io.questdb.griffin.engine.functions.constants.NullArrayConstant;
import io.questdb.griffin.engine.functions.constants.NullBinConstant;
import io.questdb.griffin.engine.functions.constants.NullConstant;
import io.questdb.griffin.engine.functions.constants.RegClassTypeConstant;
import io.questdb.griffin.engine.functions.constants.RegProcedureTypeConstant;
import io.questdb.griffin.engine.functions.constants.ShortConstant;
import io.questdb.griffin.engine.functions.constants.ShortTypeConstant;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.griffin.engine.functions.constants.StrTypeConstant;
import io.questdb.griffin.engine.functions.constants.StringArrayTypeConstant;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.griffin.engine.functions.constants.SymbolTypeConstant;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.functions.constants.TimestampTypeConstant;
import io.questdb.griffin.engine.functions.constants.UuidConstant;
import io.questdb.griffin.engine.functions.constants.UuidTypeConstant;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.griffin.engine.functions.constants.VarcharTypeConstant;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public final class Constants {
    private static final ObjList<TypeConstant> doubleArrayTypeConstants;
    private static final ObjList<ConstantFunction> geoNullConstants;
    private static final ObjList<ConstantFunction> nullConstants;
    private static final ObjList<ConstantFunction> nullDoubleArrayConstants;
    private static final ObjList<TypeConstant> typeConstants;

    public static ConstantFunction getGeoHashConstant(long hash, int bits) {
        int type = ColumnType.getGeoHashTypeWithBits(bits);
        return Constants.getGeoHashConstantWithType(hash, type);
    }

    @NotNull
    public static ConstantFunction getGeoHashConstantWithType(long hash, int type) {
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return new GeoByteConstant((byte)hash, type);
            }
            case 15: {
                return new GeoShortConstant((short)hash, type);
            }
            case 16: {
                return new GeoIntConstant((int)hash, type);
            }
        }
        return new GeoLongConstant(hash, type);
    }

    public static ConstantFunction getNullConstant(int columnType) {
        short typeTag = ColumnType.tagOf(columnType);
        switch (typeTag) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int bits = ColumnType.getGeoHashBits(columnType);
                if (bits != 0) {
                    return geoNullConstants.get(bits);
                }
                return nullConstants.getQuick(typeTag);
            }
            case 27: {
                int dim = ColumnType.decodeArrayDimensionality(columnType);
                if (dim <= nullDoubleArrayConstants.size()) {
                    return nullDoubleArrayConstants.getQuick(dim - 1);
                }
                return new NullArrayConstant(columnType);
            }
        }
        return nullConstants.getQuick(typeTag);
    }

    public static TypeConstant getTypeConstant(int columnType) {
        if (ColumnType.isArray(columnType)) {
            switch (ColumnType.decodeArrayElementType(columnType)) {
                case 10: {
                    int dim = ColumnType.decodeArrayDimensionality(columnType);
                    if (dim <= doubleArrayTypeConstants.size()) {
                        return doubleArrayTypeConstants.get(dim - 1);
                    }
                    return new ArrayTypeConstant(columnType);
                }
            }
            throw new UnsupportedOperationException();
        }
        return typeConstants.getQuick(columnType);
    }

    static {
        int i;
        doubleArrayTypeConstants = new ObjList();
        geoNullConstants = new ObjList();
        nullConstants = new ObjList(34);
        nullDoubleArrayConstants = new ObjList();
        typeConstants = new ObjList();
        nullConstants.set(0, 34, NullConstant.NULL);
        nullConstants.extendAndSet(5, IntConstant.NULL);
        nullConstants.extendAndSet(11, StrConstant.NULL);
        nullConstants.extendAndSet(12, SymbolConstant.NULL);
        nullConstants.extendAndSet(6, LongConstant.NULL);
        nullConstants.extendAndSet(7, DateConstant.NULL);
        nullConstants.extendAndSet(8, TimestampConstant.NULL);
        nullConstants.extendAndSet(2, ByteConstant.ZERO);
        nullConstants.extendAndSet(3, ShortConstant.ZERO);
        nullConstants.extendAndSet(4, CharConstant.ZERO);
        nullConstants.extendAndSet(1, BooleanConstant.FALSE);
        nullConstants.extendAndSet(10, DoubleConstant.NULL);
        nullConstants.extendAndSet(9, FloatConstant.NULL);
        nullConstants.extendAndSet(18, NullBinConstant.INSTANCE);
        nullConstants.extendAndSet(13, Long256NullConstant.INSTANCE);
        nullConstants.extendAndSet(14, GeoByteConstant.NULL);
        nullConstants.extendAndSet(15, GeoShortConstant.NULL);
        nullConstants.extendAndSet(16, GeoIntConstant.NULL);
        nullConstants.extendAndSet(24, Long128Constant.NULL);
        nullConstants.extendAndSet(17, GeoLongConstant.NULL);
        nullConstants.extendAndSet(19, UuidConstant.NULL);
        nullConstants.extendAndSet(25, IPv4Constant.NULL);
        nullConstants.extendAndSet(26, VarcharConstant.NULL);
        nullConstants.extendAndSet(32, IntervalConstant.NULL);
        nullConstants.setPos(34);
        typeConstants.extendAndSet(5, IntTypeConstant.INSTANCE);
        typeConstants.extendAndSet(11, StrTypeConstant.INSTANCE);
        typeConstants.extendAndSet(12, SymbolTypeConstant.INSTANCE);
        typeConstants.extendAndSet(6, LongTypeConstant.INSTANCE);
        typeConstants.extendAndSet(7, DateTypeConstant.INSTANCE);
        typeConstants.extendAndSet(8, TimestampTypeConstant.INSTANCE);
        typeConstants.extendAndSet(2, ByteTypeConstant.INSTANCE);
        typeConstants.extendAndSet(3, ShortTypeConstant.INSTANCE);
        typeConstants.extendAndSet(4, CharTypeConstant.INSTANCE);
        typeConstants.extendAndSet(1, BooleanTypeConstant.INSTANCE);
        typeConstants.extendAndSet(10, DoubleTypeConstant.INSTANCE);
        typeConstants.extendAndSet(9, FloatTypeConstant.INSTANCE);
        typeConstants.extendAndSet(18, BinTypeConstant.INSTANCE);
        typeConstants.extendAndSet(13, Long256TypeConstant.INSTANCE);
        typeConstants.extendAndSet(28, RegClassTypeConstant.INSTANCE);
        typeConstants.extendAndSet(29, RegProcedureTypeConstant.INSTANCE);
        typeConstants.extendAndSet(30, StringArrayTypeConstant.INSTANCE);
        typeConstants.extendAndSet(19, UuidTypeConstant.INSTANCE);
        typeConstants.extendAndSet(25, IPv4TypeConstant.INSTANCE);
        typeConstants.extendAndSet(26, VarcharTypeConstant.INSTANCE);
        typeConstants.extendAndSet(32, IntervalTypeConstant.INSTANCE);
        for (i = 0; i < 10; ++i) {
            doubleArrayTypeConstants.add(new ArrayTypeConstant(ColumnType.encodeArrayType((short)10, i + 1)));
        }
        for (int b = 1; b <= 60; ++b) {
            geoNullConstants.extendAndSet(b, Constants.getGeoHashConstant(-1L, b));
        }
        for (i = 0; i < 10; ++i) {
            nullDoubleArrayConstants.add(new NullArrayConstant(ColumnType.encodeArrayType((short)10, i + 1)));
        }
    }
}

