/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.str.Utf8Sequence;

public class ContainsEqIPv4Utils {
    private ContainsEqIPv4Utils() {
    }

    public static Function containsIPv4Str(Function ipv4Func, Function strFunc, int strFuncPosition) throws SqlException {
        if (strFunc.isConstant()) {
            CharSequence constValue = strFunc.getStrA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            try {
                long subnetAndNetmask = Numbers.getIPv4Subnet(constValue);
                int subnet = (int)(subnetAndNetmask >> 32);
                int netmask = (int)subnetAndNetmask;
                return new ConstStrFunc(ipv4Func, subnet & netmask, netmask);
            }
            catch (NumericException ne) {
                throw SqlException.$(strFuncPosition, "invalid argument: ").put(constValue);
            }
        }
        if (strFunc.isRuntimeConstant()) {
            return new RuntimeConstStrFunc(ipv4Func, strFunc, strFuncPosition);
        }
        return new StrFunc(ipv4Func, strFunc);
    }

    public static Function containsIPv4Varchar(Function ipv4Func, Function varcharFunc, int varcharFuncPosition) throws SqlException {
        if (varcharFunc.isConstant()) {
            CharSequence constValue = varcharFunc.getStrA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            try {
                long subnetAndNetmask = Numbers.getIPv4Subnet(constValue);
                int subnet = (int)(subnetAndNetmask >> 32);
                int netmask = (int)subnetAndNetmask;
                return new ConstStrFunc(ipv4Func, subnet & netmask, netmask);
            }
            catch (NumericException ne) {
                throw SqlException.$(varcharFuncPosition, "invalid argument: ").put(constValue);
            }
        }
        if (varcharFunc.isRuntimeConstant()) {
            return new RuntimeConstStrFunc(ipv4Func, varcharFunc, varcharFuncPosition);
        }
        return new VarcharFunc(ipv4Func, varcharFunc);
    }

    private static class ConstStrFunc
    extends BooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final int netmask;
        private final int subnet;

        public ConstStrFunc(Function arg, int subnet, int netmask) {
            this.arg = arg;
            this.subnet = subnet;
            this.netmask = netmask;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return (this.arg.getIPv4(rec) & this.netmask) == this.subnet;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            sink.val("<<=").val(this.subnet).val('\'');
        }
    }

    private static class RuntimeConstStrFunc
    extends BooleanFunction
    implements BinaryFunction {
        private final Function ipv4Func;
        private final Function strFunc;
        private final int strFuncPosition;
        private int netmask;
        private int subnet;

        public RuntimeConstStrFunc(Function ipv4Func, Function strFunc, int strFuncPosition) {
            this.ipv4Func = ipv4Func;
            this.strFunc = strFunc;
            this.strFuncPosition = strFuncPosition;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.subnet != 0 && (this.ipv4Func.getIPv4(rec) & this.netmask) == this.subnet;
        }

        @Override
        public Function getLeft() {
            return this.ipv4Func;
        }

        @Override
        public Function getRight() {
            return this.strFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence value = this.strFunc.getStrA(null);
            if (value == null) {
                this.subnet = 0;
                this.netmask = -1;
            } else {
                try {
                    long subnetAndNetmask = Numbers.getIPv4Subnet(value);
                    this.subnet = (int)(subnetAndNetmask >> 32);
                    this.netmask = (int)subnetAndNetmask;
                    this.subnet &= this.netmask;
                }
                catch (NumericException ne) {
                    throw SqlException.$(this.strFuncPosition, "invalid argument: ").put(value);
                }
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.ipv4Func);
            sink.val("<<=").val(this.strFunc).val('\'');
        }
    }

    private static class StrFunc
    extends BooleanFunction
    implements BinaryFunction {
        private final Function ipv4Func;
        private final Function strFunc;

        public StrFunc(Function ipv4Func, Function strFunc) {
            this.ipv4Func = ipv4Func;
            this.strFunc = strFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            int netmask;
            CharSequence value = this.strFunc.getStrA(rec);
            if (value == null) {
                return false;
            }
            try {
                long subnetAndNetmask = Numbers.getIPv4Subnet(value);
                int subnet = (int)(subnetAndNetmask >> 32);
                netmask = (int)subnetAndNetmask;
            }
            catch (NumericException ne) {
                return false;
            }
            return (this.ipv4Func.getIPv4(rec) & netmask) == (subnet &= netmask);
        }

        @Override
        public Function getLeft() {
            return this.ipv4Func;
        }

        @Override
        public Function getRight() {
            return this.strFunc;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.ipv4Func);
            sink.val("<<=").val(this.strFunc).val('\'');
        }
    }

    private static class VarcharFunc
    extends BooleanFunction
    implements BinaryFunction {
        private final Function ipv4Func;
        private final Function varcharFunc;

        public VarcharFunc(Function ipv4Func, Function varcharFunc) {
            this.ipv4Func = ipv4Func;
            this.varcharFunc = varcharFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            int netmask;
            Utf8Sequence value = this.varcharFunc.getVarcharA(rec);
            if (value == null) {
                return false;
            }
            try {
                long subnetAndNetmask = Numbers.getIPv4Subnet(value.asAsciiCharSequence());
                int subnet = (int)(subnetAndNetmask >> 32);
                netmask = (int)subnetAndNetmask;
            }
            catch (NumericException ne) {
                return false;
            }
            return (this.ipv4Func.getIPv4(rec) & netmask) == (subnet &= netmask);
        }

        @Override
        public Function getLeft() {
            return this.ipv4Func;
        }

        @Override
        public Function getRight() {
            return this.varcharFunc;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.ipv4Func);
            sink.val("<<=").val(this.varcharFunc).val('\'');
        }
    }
}

