/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class EqDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(DD)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function left = args.getQuick(0);
        Function right = args.getQuick(1);
        int leftType = left.getType();
        int rightType = right.getType();
        if (EqDoubleFunctionFactory.isNullConstant(left, leftType)) {
            return EqDoubleFunctionFactory.dispatchUnaryFunc(right, rightType);
        }
        if (EqDoubleFunctionFactory.isNullConstant(right, rightType)) {
            return EqDoubleFunctionFactory.dispatchUnaryFunc(left, leftType);
        }
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static Function dispatchUnaryFunc(Function operand, int operandType) {
        switch (ColumnType.tagOf(operandType)) {
            case 5: {
                return new FuncIntIsNaN(operand);
            }
            case 6: {
                return new FuncLongIsNaN(operand);
            }
            case 7: {
                return new FuncDateIsNaN(operand);
            }
            case 8: {
                return new FuncTimestampIsNaN(operand);
            }
            case 9: {
                return new FuncFloatIsNaN(operand);
            }
        }
        return new FuncDoubleIsNaN(operand);
    }

    private static boolean isNullConstant(Function operand, int operandType) {
        return operand.isConstant() && (ColumnType.isDouble(operandType) && Numbers.isNull(operand.getDouble(null)) || operandType == 33);
    }

    protected static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function left, Function right) {
            super(left, right);
        }

        @Override
        public boolean getBool(Record rec) {
            double r;
            double l = this.left.getDouble(rec);
            return this.negated != Numbers.equals(l, r = this.right.getDouble(rec));
        }
    }

    protected static class FuncIntIsNaN
    extends AbstractIsNaNFunction {
        public FuncIntIsNaN(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getInt(rec) == Integer.MIN_VALUE);
        }
    }

    protected static class FuncLongIsNaN
    extends AbstractIsNaNFunction {
        public FuncLongIsNaN(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getLong(rec) == Long.MIN_VALUE);
        }
    }

    protected static class FuncDateIsNaN
    extends AbstractIsNaNFunction {
        public FuncDateIsNaN(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getDate(rec) == Long.MIN_VALUE);
        }
    }

    protected static class FuncTimestampIsNaN
    extends AbstractIsNaNFunction {
        public FuncTimestampIsNaN(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getTimestamp(rec) == Long.MIN_VALUE);
        }
    }

    protected static class FuncFloatIsNaN
    extends AbstractIsNaNFunction {
        public FuncFloatIsNaN(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Numbers.isNull(this.arg.getFloat(rec));
        }
    }

    protected static class FuncDoubleIsNaN
    extends AbstractIsNaNFunction {
        public FuncDoubleIsNaN(Function arg) {
            super(arg);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Numbers.isNull(this.arg.getDouble(rec));
        }
    }

    protected static abstract class AbstractIsNaNFunction
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public AbstractIsNaNFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val(" is not null");
            } else {
                sink.val(" is null");
            }
        }
    }
}

