/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.AbstractCountGroupByFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import org.jetbrains.annotations.NotNull;

public class CountLong256GroupByFunction
extends AbstractCountGroupByFunction {
    public CountLong256GroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        Long256 value = this.arg.getLong256A(record);
        if (!Long256Impl.isNull(value)) {
            mapValue.putLong(this.valueIndex, 1L);
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        Long256 value = this.arg.getLong256A(record);
        if (!Long256Impl.isNull(value)) {
            mapValue.addLong(this.valueIndex, 1L);
        }
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }
}

