/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.AbstractCovarGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class CovarSampleGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "covar_samp(DD)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CovarSampleGroupByFunction(args.getQuick(0), args.getQuick(1));
    }

    public static class CovarSampleGroupByFunction
    extends AbstractCovarGroupByFunction {
        protected CovarSampleGroupByFunction(@NotNull Function arg0, @NotNull Function arg1) {
            super(arg0, arg1);
        }

        @Override
        public double getDouble(Record rec) {
            long count = rec.getLong(this.valueIndex + 3);
            if (count - 1L > 0L) {
                double sumXY = rec.getDouble(this.valueIndex + 2);
                return sumXY / (double)(count - 1L);
            }
            return Double.NaN;
        }

        @Override
        public String getName() {
            return "covar_samp";
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            double srcMeanY = srcValue.getDouble(this.valueIndex);
            double srcMeanX = srcValue.getDouble(this.valueIndex + 1);
            double srcSumXY = srcValue.getDouble(this.valueIndex + 2);
            long srcCount = srcValue.getLong(this.valueIndex + 3);
            double destMeanY = destValue.getDouble(this.valueIndex);
            double destMeanX = destValue.getDouble(this.valueIndex + 1);
            double destSumXY = destValue.getDouble(this.valueIndex + 2);
            long destCount = destValue.getLong(this.valueIndex + 3);
            long mergedCount = srcCount + destCount;
            double deltaY = destMeanY - srcMeanY;
            double deltaX = destMeanX - srcMeanX;
            double mergedMeanY = ((double)srcCount * srcMeanY + (double)destCount * destMeanY) / (double)mergedCount;
            double mergedMeanX = ((double)srcCount * srcMeanX + (double)destCount * destMeanX) / (double)mergedCount;
            double mergedSumXY = srcSumXY + destSumXY + deltaY * deltaX * ((double)srcCount * (double)destCount / (double)mergedCount);
            destValue.putDouble(this.valueIndex, mergedMeanY);
            destValue.putDouble(this.valueIndex + 1, mergedMeanX);
            destValue.putDouble(this.valueIndex + 2, mergedSumXY);
            destValue.putLong(this.valueIndex + 3, mergedCount);
        }

        @Override
        public boolean supportsParallelism() {
            return true;
        }
    }
}

