/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf16Sink;

class StringDistinctAggGroupByFunction
extends StrFunction
implements UnaryFunction,
GroupByFunction {
    private static final int INITIAL_SINK_CAPACITY = 128;
    private final Function arg;
    private final char delimiter;
    private final int setInitialCapacity;
    private final double setLoadFactor;
    private final ObjList<CharSequenceHashSet> sets = new ObjList();
    private final DirectUtf16Sink sinkA;
    private final DirectUtf16Sink sinkB;
    private int setIndex = 0;
    private int valueIndex;

    public StringDistinctAggGroupByFunction(Function arg, char delimiter, int setInitialCapacity, double setLoadFactor) {
        try {
            this.arg = arg;
            this.delimiter = delimiter;
            this.setInitialCapacity = setInitialCapacity;
            this.setLoadFactor = setLoadFactor;
            this.sinkA = new DirectUtf16Sink(128L);
            this.sinkB = new DirectUtf16Sink(128L);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        this.sets.clear();
        this.sinkA.resetCapacity();
        this.sinkB.resetCapacity();
        this.setIndex = 0;
    }

    @Override
    public void close() {
        Misc.free(this.sinkA);
        Misc.free(this.sinkB);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        CharSequenceHashSet set;
        if (this.sets.size() <= this.setIndex) {
            set = new CharSequenceHashSet(this.setInitialCapacity, this.setLoadFactor);
            this.sets.extendAndSet(this.setIndex, set);
        } else {
            set = this.sets.getQuick(this.setIndex);
            set.clear();
        }
        CharSequence str = this.arg.getStrA(record);
        if (str != null) {
            set.add(str);
        }
        mapValue.putInt(this.valueIndex, this.setIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        CharSequenceHashSet set = this.sets.getQuick(mapValue.getInt(this.valueIndex));
        CharSequence str = this.arg.getStrA(record);
        if (str != null) {
            set.add(str);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public CharSequence getStrA(Record rec) {
        return this.getStr(rec, this.sinkA);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getStr(rec, this.sinkB);
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putInt(this.valueIndex, -1);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("string_distinct_agg(").val(this.arg).val(',').val(this.delimiter).val(')');
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.setIndex = 0;
    }

    private CharSequence getStr(Record rec, DirectUtf16Sink sink) {
        int setIndex = rec.getInt(this.valueIndex);
        if (setIndex == -1) {
            return null;
        }
        CharSequenceHashSet set = this.sets.getQuick(setIndex);
        if (set.size() == 0) {
            return null;
        }
        sink.clear();
        ObjList<CharSequence> list = set.getList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.putAscii(this.delimiter);
            }
            sink.put(set.get(i));
        }
        return sink;
    }
}

