/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.AbstractStdDevGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class VarSampleGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "var_samp(D)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new VarSampleGroupByFunction(args.getQuick(0));
    }

    public static class VarSampleGroupByFunction
    extends AbstractStdDevGroupByFunction {
        public VarSampleGroupByFunction(@NotNull Function arg) {
            super(arg);
        }

        @Override
        public double getDouble(Record rec) {
            long count = rec.getLong(this.valueIndex + 2);
            if (count - 1L > 0L) {
                double sum = rec.getDouble(this.valueIndex + 1);
                return sum / (double)(count - 1L);
            }
            return Double.NaN;
        }

        @Override
        public String getName() {
            return "var_samp";
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            double srcMean = srcValue.getDouble(this.valueIndex);
            double srcSum = srcValue.getDouble(this.valueIndex + 1);
            long srcCount = srcValue.getLong(this.valueIndex + 2);
            double destMean = destValue.getDouble(this.valueIndex);
            double destSum = destValue.getDouble(this.valueIndex + 1);
            long destCount = destValue.getLong(this.valueIndex + 2);
            long mergedCount = srcCount + destCount;
            double delta = destMean - srcMean;
            double mergedMean = ((double)srcCount * srcMean + (double)destCount * destMean) / (double)mergedCount;
            double mergedSum = srcSum + destSum + delta * delta * ((double)srcCount * (double)destCount / (double)mergedCount);
            destValue.putDouble(this.valueIndex, mergedMean);
            destValue.putDouble(this.valueIndex + 1, mergedSum);
            destValue.putLong(this.valueIndex + 2, mergedCount);
        }

        @Override
        public boolean supportsParallelism() {
            return true;
        }
    }
}

