/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.json;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.json.JsonExtractFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class JsonExtractTypedFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "json_extract(\u00d8\u00d8i)";

    public static boolean isIntrusivelyOptimized(int columnType) {
        switch (columnType) {
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function json = args.getQuick(0);
        Function path = args.getQuick(1);
        if (path.getType() != 0 && !path.isConstant() && !path.isRuntimeConstant()) {
            Misc.freeObjList(args);
            throw SqlException.$(argPositions.getQuick(1), "constant or bind variable expected");
        }
        return new JsonExtractFunction(JsonExtractTypedFunctionFactory.parseTargetType(position, args.getQuick(2)), json, path, configuration.getStrFunctionMaxBufferLength());
    }

    private static int parseTargetType(int position, Function targetTypeFn) throws SqlException {
        int targetType;
        if (targetTypeFn != null && targetTypeFn.isConstant() && JsonExtractTypedFunctionFactory.isIntrusivelyOptimized(targetType = targetTypeFn.getInt(null))) {
            return targetType;
        }
        throw SqlException.position(position).put("please use json_extract(json,path)::type semantic");
    }
}

