/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class IPv4MinusIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "-(XX)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new IPv4MinusIPv4Function(args.getQuick(0), args.getQuick(1));
    }

    public static final class IPv4MinusIPv4Function
    extends LongFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public IPv4MinusIPv4Function(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public long getLong(Record rec) {
            long l = Numbers.ipv4ToLong(this.left.getIPv4(rec));
            long r = Numbers.ipv4ToLong(this.right.getIPv4(rec));
            return l != 0L && r != 0L ? l - r : Long.MIN_VALUE;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left).val('+').val(this.right);
        }
    }
}

