/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.regex.MatchStrFunctionFactory;
import io.questdb.griffin.engine.functions.regex.RegexUtils;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.regex.Matcher;

public class MatchSymbolFunctionFactory
implements FunctionFactory {
    public static boolean symbolMatches(Function arg, Record rec, IntList symbolKeys) {
        int key = arg.getInt(rec);
        if (key != Integer.MIN_VALUE) {
            return symbolKeys.binarySearchUniqueList(key) > -1;
        }
        return false;
    }

    @Override
    public String getSignature() {
        return "~(KS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        SymbolFunction func = (SymbolFunction)args.getQuick(0);
        Function pattern = args.getQuick(1);
        int patternPosition = argPositions.getQuick(1);
        if (func.isSymbolTableStatic()) {
            if (pattern.isConstant()) {
                Matcher matcher = RegexUtils.createMatcher(pattern, patternPosition);
                if (matcher == null) {
                    return BooleanConstant.FALSE;
                }
                return new MatchStaticSymbolTableConstPatternFunction(func, matcher);
            }
            if (pattern.isRuntimeConstant()) {
                return new MatchStaticSymbolTableRuntimeConstPatternFunction(func, pattern, patternPosition);
            }
        } else {
            if (pattern.isConstant()) {
                Matcher matcher = RegexUtils.createMatcher(pattern, patternPosition);
                if (matcher == null) {
                    return BooleanConstant.FALSE;
                }
                return new MatchStrFunctionFactory.MatchStrConstPatternFunction(func, matcher);
            }
            if (pattern.isRuntimeConstant()) {
                return new MatchStrFunctionFactory.MatchStrRuntimeConstPatternFunction(func, pattern, patternPosition);
            }
        }
        throw SqlException.$(patternPosition, "not implemented: dynamic pattern would be very slow to execute");
    }

    private static void extractSymbolKeys(SymbolFunction symbolFun, IntList symbolKeys, Matcher matcher) {
        StaticSymbolTable symbolTable = symbolFun.getStaticSymbolTable();
        assert (symbolTable != null);
        symbolKeys.clear();
        if (matcher != null) {
            int n = symbolTable.getSymbolCount();
            for (int i = 0; i < n; ++i) {
                if (!matcher.reset(symbolTable.valueOf(i)).find()) continue;
                symbolKeys.add(i);
            }
        }
    }

    private static class MatchStaticSymbolTableConstPatternFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Matcher matcher;
        private final SymbolFunction symbolFun;
        private final IntList symbolKeys = new IntList();
        private boolean initialized;

        public MatchStaticSymbolTableConstPatternFunction(SymbolFunction symbolFun, Matcher matcher) {
            this.symbolFun = symbolFun;
            this.matcher = matcher;
        }

        @Override
        public Function getArg() {
            return this.symbolFun;
        }

        @Override
        public boolean getBool(Record rec) {
            if (!this.initialized) {
                MatchSymbolFunctionFactory.extractSymbolKeys(this.symbolFun, this.symbolKeys, this.matcher);
                this.initialized = true;
            }
            return MatchSymbolFunctionFactory.symbolMatches(this.symbolFun, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            this.initialized = false;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.symbolFun).val(" ~ ").val(this.matcher.pattern().toString());
        }
    }

    private static class MatchStaticSymbolTableRuntimeConstPatternFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function pattern;
        private final int patternPosition;
        private final SymbolFunction symbolFun;
        private final IntList symbolKeys = new IntList();
        private boolean initialized;
        private Matcher matcher;

        public MatchStaticSymbolTableRuntimeConstPatternFunction(SymbolFunction symbolFun, Function pattern, int patternPosition) {
            this.symbolFun = symbolFun;
            this.pattern = pattern;
            this.patternPosition = patternPosition;
        }

        @Override
        public Function getArg() {
            return this.symbolFun;
        }

        @Override
        public boolean getBool(Record rec) {
            if (!this.initialized) {
                MatchSymbolFunctionFactory.extractSymbolKeys(this.symbolFun, this.symbolKeys, this.matcher);
                this.initialized = true;
            }
            return MatchSymbolFunctionFactory.symbolMatches(this.symbolFun, rec, this.symbolKeys);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            UnaryFunction.super.init(symbolTableSource, executionContext);
            this.pattern.init(symbolTableSource, executionContext);
            this.matcher = RegexUtils.createMatcher(this.pattern, this.patternPosition);
            this.initialized = false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public boolean isRuntimeConstant() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.symbolFun).val(" ~ ").val(this.pattern.toString());
        }
    }
}

