/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinFunction;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndBinFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_bin()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new FixLenFunction();
    }

    private static final class FixLenFunction
    extends BinFunction
    implements Function {
        private final Sequence sequence = new Sequence();

        public FixLenFunction() {
            this.sequence.len = 32L;
        }

        @Override
        public BinarySequence getBin(Record rec) {
            return this.sequence;
        }

        @Override
        public long getBinLen(Record rec) {
            return this.sequence.len;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.sequence.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_bin()");
        }
    }

    private static class Sequence
    implements BinarySequence {
        private long len;
        private Rnd rnd;

        private Sequence() {
        }

        @Override
        public byte byteAt(long index) {
            return this.rnd.nextByte();
        }

        @Override
        public long length() {
            return this.len;
        }
    }
}

