/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndIPv4CCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_ipv4(ii)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence subnetStr = args.getQuick(0).getStrA(null);
        int nullRate = args.getQuick(1).getInt(null);
        try {
            long subnetAndBroadcast = Numbers.getBroadcastAddress(subnetStr);
            int subnet = (int)(subnetAndBroadcast >> 32);
            int broadcast = (int)subnetAndBroadcast;
            return new RndFunction(subnet, broadcast, nullRate);
        }
        catch (NumericException ne) {
            throw SqlException.$(argPositions.getQuick(0), "invalid argument: ").put(subnetStr);
        }
    }

    private static class RndFunction
    extends IPv4Function
    implements Function {
        private final int lo;
        private final int nullRate;
        private final int range;
        private Rnd rnd;

        public RndFunction(int lo, int hi, int nullRate) {
            this.lo = lo;
            this.range = hi - lo + 1;
            this.nullRate = nullRate + 1;
        }

        @Override
        public int getIPv4(Record rec) {
            if (this.rnd.nextInt() % this.nullRate == 1) {
                return 0;
            }
            return this.lo + this.rnd.nextPositiveInt() % this.range;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public boolean shouldMemoize() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_ipv4(").val(this.lo).val(',').val(this.range + this.lo - 1).val(this.nullRate - 1).val(')');
        }
    }
}

