/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndLogFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(RndLogFunctionFactory.class);

    @Override
    public String getSignature() {
        return "rnd_log(ld)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        if (configuration.isDevModeEnabled()) {
            return new TestLogFunction(args.getQuick(0).getLong(null), args.getQuick(1).getDouble(null) % 100.0);
        }
        return BooleanConstant.FALSE;
    }

    private static class TestLogFunction
    extends BooleanFunction {
        private final double errorRatio;
        private final long totalLogLines;
        private Rnd rnd;

        public TestLogFunction(long totalLogLines, double errorRatio) {
            this.totalLogLines = totalLogLines;
            this.errorRatio = errorRatio;
        }

        @Override
        public boolean getBool(Record rec) {
            for (long l = 0L; l < this.totalLogLines; ++l) {
                LogRecord log = this.rnd.nextDouble() * 10000.0 < this.errorRatio * 100.0 ? LOG.error() : LOG.info();
                log.$(this.rnd.nextString(25)).$();
            }
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            executionContext.getSecurityContext().authorizeSystemAdmin();
            super.init(symbolTableSource, executionContext);
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_log(").val(this.totalLogLines).val(',').val(this.errorRatio).val(')');
        }
    }
}

