/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class QuoteIdentFunctionFactory
implements FunctionFactory {
    private static final String NAME = "quote_ident";

    @Override
    public String getSignature() {
        return "quote_ident(S)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            CharSequence val = arg.getStrA(null);
            if (val == null) {
                return StrConstant.NULL;
            }
            StringSink quotedVal = QuoteIdentFunction.quote(Misc.getThreadLocalSink(), val);
            return new StrConstant(quotedVal.toString());
        }
        return new QuoteIdentFunction(arg);
    }

    static class QuoteIdentFunction
    extends StrFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public QuoteIdentFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public String getName() {
            return QuoteIdentFunctionFactory.NAME;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return QuoteIdentFunction.quote(this.sinkA, this.arg.getStrA(rec));
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return QuoteIdentFunction.quote(this.sinkB, this.arg.getStrA(rec));
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static StringSink quote(StringSink sink, CharSequence str) {
            char c;
            int i;
            if (str == null) {
                return null;
            }
            sink.clear();
            boolean needsQuoting = false;
            int len = str.length();
            for (i = 0; i < len; ++i) {
                c = str.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '$') continue;
                needsQuoting = true;
                break;
            }
            if (!needsQuoting) {
                sink.put(str);
            } else {
                sink.put('\"');
                for (i = 0; i < len; ++i) {
                    c = str.charAt(i);
                    if (c != '\"') {
                        sink.put(c);
                        continue;
                    }
                    sink.put('\"').put('\"');
                }
                sink.put('\"');
            }
            return sink;
        }
    }
}

