/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.Nullable;

public class SplitPartVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "split_part(\u00d8\u00d8I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function varcharFunc = args.getQuick(0);
        Function delimiterFunc = args.getQuick(1);
        Function indexFunc = args.getQuick(2);
        int indexPosition = argPositions.getQuick(2);
        if (indexFunc.isConstant()) {
            int index = indexFunc.getInt(null);
            if (index == Integer.MIN_VALUE) {
                return VarcharConstant.NULL;
            }
            if (index == 0) {
                throw SqlException.$(indexPosition, "field position must not be zero");
            }
            return new SplitPartVarcharConstIndexFunction(varcharFunc, delimiterFunc, indexFunc, indexPosition, index);
        }
        if (!indexFunc.isRuntimeConstant()) {
            throw SqlException.$(indexPosition, "index must be either a constant expression or a placeholder");
        }
        return new SplitPartVarcharFunction(varcharFunc, delimiterFunc, indexFunc, indexPosition);
    }

    private static void splitToSink(Utf8Sink sink, int index, Utf8Sequence utf8Str, Utf8Sequence delimiter) {
        int end;
        int start;
        if (index == 0) {
            return;
        }
        int size = utf8Str.size();
        int len = Utf8s.length(utf8Str);
        if (index > 0) {
            if (index == 1) {
                start = 0;
            } else {
                start = Utf8s.indexOf(utf8Str, 0, size, delimiter, index - 1);
                if (start == -1) {
                    return;
                }
                start += delimiter.size();
            }
            end = Utf8s.indexOf(utf8Str, start, size, delimiter);
            if (end == -1) {
                end = len;
            }
        } else {
            if (index == -1) {
                end = size;
            } else {
                end = Utf8s.indexOf(utf8Str, 0, size, delimiter, index + 1);
                if (end == -1) {
                    return;
                }
            }
            start = Utf8s.indexOf(utf8Str, 0, end, delimiter, -1);
            start = start == -1 ? 0 : (start += delimiter.size());
        }
        sink.put(utf8Str, start, end);
    }

    private static class SplitPartVarcharConstIndexFunction
    extends AbstractSplitPartVarcharFunction {
        private final int index;

        public SplitPartVarcharConstIndexFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition, int index) {
            super(strFunc, delimiterFunc, indexFunc, indexPosition);
            this.index = index;
        }

        @Override
        int getIndex(Record rec) {
            return this.index;
        }
    }

    private static class SplitPartVarcharFunction
    extends AbstractSplitPartVarcharFunction
    implements TernaryFunction {
        public SplitPartVarcharFunction(Function varcharFunc, Function delimiterFunc, Function indexFunc, int indexPosition) {
            super(varcharFunc, delimiterFunc, indexFunc, indexPosition);
        }

        @Override
        int getIndex(Record rec) {
            return this.indexFunc.getInt(rec);
        }
    }

    private static abstract class AbstractSplitPartVarcharFunction
    extends VarcharFunction
    implements TernaryFunction {
        protected final Function delimiterFunc;
        protected final Function indexFunc;
        protected final Function varcharFunc;
        private final int indexPosition;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();

        public AbstractSplitPartVarcharFunction(Function varcharFunc, Function delimiterFunc, Function indexFunc, int indexPosition) {
            this.varcharFunc = varcharFunc;
            this.delimiterFunc = delimiterFunc;
            this.indexFunc = indexFunc;
            this.indexPosition = indexPosition;
        }

        @Override
        public final Function getCenter() {
            return this.delimiterFunc;
        }

        @Override
        public final Function getLeft() {
            return this.varcharFunc;
        }

        @Override
        public String getName() {
            return "split_part";
        }

        @Override
        public final Function getRight() {
            return this.indexFunc;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            return this.getVarcharWithClear(rec, this.sinkA);
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            return this.getVarcharWithClear(rec, this.sinkB);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            int index;
            TernaryFunction.super.init(symbolTableSource, executionContext);
            if (this.indexFunc.isRuntimeConstant() && (index = this.indexFunc.getInt(null)) == 0) {
                throw SqlException.$(this.indexPosition, "field position must not be zero");
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Nullable
        private Utf8StringSink getVarcharWithClear(Record rec, Utf8StringSink sink) {
            sink.clear();
            Utf8Sequence utf8Str = this.varcharFunc.getVarcharA(rec);
            Utf8Sequence delimiter = this.delimiterFunc.getVarcharA(rec);
            int index = this.getIndex(rec);
            if (utf8Str == null || delimiter == null || index == Integer.MIN_VALUE) {
                return null;
            }
            SplitPartVarcharFunctionFactory.splitToSink(sink, index, utf8Str, delimiter);
            return sink;
        }

        abstract int getIndex(Record var1);
    }
}

