/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.ObjList;
import io.questdb.std.ex.BytecodeException;
import org.jetbrains.annotations.NotNull;

public class GroupByFunctionsUpdaterFactory {
    private static final int FIELD_POOL_OFFSET = 3;
    private static final Log LOG = LogFactory.getLog(GroupByFunctionsUpdaterFactory.class);

    private GroupByFunctionsUpdaterFactory() {
    }

    public static GroupByFunctionsUpdater getInstance(BytecodeAssembler asm, @NotNull ObjList<GroupByFunction> groupByFunctions) {
        Class<GroupByFunctionsUpdater> clazz = GroupByFunctionsUpdaterFactory.getInstanceClass(asm, groupByFunctions.size());
        return GroupByFunctionsUpdaterFactory.getInstance(clazz, groupByFunctions);
    }

    public static GroupByFunctionsUpdater getInstance(Class<GroupByFunctionsUpdater> clazz, @NotNull ObjList<GroupByFunction> groupByFunctions) {
        try {
            GroupByFunctionsUpdater updater = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            updater.setFunctions(groupByFunctions);
            return updater;
        }
        catch (Exception e) {
            LOG.critical().$("could not create an instance of GroupByFunctionsUpdater, cause: ").$(e).$();
            throw BytecodeException.INSTANCE;
        }
    }

    public static Class<GroupByFunctionsUpdater> getInstanceClass(BytecodeAssembler asm, int functionCount) {
        asm.init(GroupByFunctionsUpdater.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/griffin/engine/groupby/GroupByFunctionsUpdaterAsm"));
        int superclassIndex = asm.poolClass(Object.class);
        int interfaceClassIndex = asm.poolClass(GroupByFunctionsUpdater.class);
        int superIndex = asm.poolMethod(superclassIndex, (CharSequence)"<init>", (CharSequence)"()V");
        int typeIndex = asm.poolUtf8("Lio/questdb/griffin/engine/functions/GroupByFunction;");
        int firstFieldNameIndex = 0;
        int firstFieldIndex = 0;
        for (int i = 0; i < functionCount; ++i) {
            int fieldNameIndex = asm.poolUtf8().putAscii("f").put(i).$();
            int nameAndType = asm.poolNameAndType(fieldNameIndex, typeIndex);
            int fieldIndex = asm.poolField(thisClassIndex, nameAndType);
            if (i != 0) continue;
            firstFieldNameIndex = fieldNameIndex;
            firstFieldIndex = fieldIndex;
        }
        int computeFirstIndex = asm.poolInterfaceMethod(GroupByFunction.class, "computeFirst", "(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;J)V");
        int computeNextIndex = asm.poolInterfaceMethod(GroupByFunction.class, "computeNext", "(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;J)V");
        int setEmptyIndex = asm.poolInterfaceMethod(GroupByFunction.class, "setEmpty", "(Lio/questdb/cairo/map/MapValue;)V");
        int mergeFunctionIndex = asm.poolInterfaceMethod(GroupByFunction.class, "merge", "(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/map/MapValue;)V");
        int updateNewIndex = asm.poolUtf8("updateNew");
        int updateNewSigIndex = asm.poolUtf8("(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;J)V");
        int updateExistingIndex = asm.poolUtf8("updateExisting");
        int updateExistingSigIndex = asm.poolUtf8("(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/sql/Record;J)V");
        int updateEmptyIndex = asm.poolUtf8("updateEmpty");
        int updateEmptySigIndex = asm.poolUtf8("(Lio/questdb/cairo/map/MapValue;)V");
        int setFunctionsIndex = asm.poolUtf8("setFunctions");
        int setFunctionsSigIndex = asm.poolUtf8("(Lio/questdb/std/ObjList;)V");
        int mergeIndex = asm.poolUtf8("merge");
        int mergeSigIndex = asm.poolUtf8("(Lio/questdb/cairo/map/MapValue;Lio/questdb/cairo/map/MapValue;)V");
        int getIndex = asm.poolMethod(ObjList.class, (CharSequence)"get", (CharSequence)"(I)Ljava/lang/Object;");
        asm.finishPool();
        asm.defineClass(thisClassIndex, superclassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(functionCount);
        for (int i = 0; i < functionCount; ++i) {
            asm.defineField(firstFieldNameIndex + i * 3, typeIndex);
        }
        asm.methodCount(6);
        asm.defineDefaultConstructor(superIndex);
        GroupByFunctionsUpdaterFactory.generateUpdateNew(asm, functionCount, firstFieldIndex, computeFirstIndex, updateNewIndex, updateNewSigIndex);
        GroupByFunctionsUpdaterFactory.generateUpdateExisting(asm, functionCount, firstFieldIndex, computeNextIndex, updateExistingIndex, updateExistingSigIndex);
        GroupByFunctionsUpdaterFactory.generateUpdateEmpty(asm, functionCount, firstFieldIndex, setEmptyIndex, updateEmptyIndex, updateEmptySigIndex);
        GroupByFunctionsUpdaterFactory.generateSetFunctions(asm, functionCount, firstFieldIndex, setFunctionsIndex, setFunctionsSigIndex, getIndex);
        GroupByFunctionsUpdaterFactory.generateMerge(asm, functionCount, firstFieldIndex, mergeFunctionIndex, mergeIndex, mergeSigIndex);
        asm.putShort(0);
        return asm.loadClass();
    }

    private static void generateMerge(BytecodeAssembler asm, int fieldCount, int firstFieldIndex, int mergeFunctionIndex, int mergeIndex, int mergeSigIndex) {
        asm.startMethod(mergeIndex, mergeSigIndex, 3, 3);
        for (int i = 0; i < fieldCount; ++i) {
            asm.aload(0);
            asm.getfield(firstFieldIndex + i * 3);
            asm.aload(1);
            asm.aload(2);
            asm.invokeInterface(mergeFunctionIndex, 2);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static void generateSetFunctions(BytecodeAssembler asm, int functionSize, int firstFieldIndex, int setFunctionsIndex, int setFunctionsSigIndex, int getIndex) {
        asm.startMethod(setFunctionsIndex, setFunctionsSigIndex, 3, 3);
        for (int i = 0; i < functionSize; ++i) {
            asm.aload(0);
            asm.aload(1);
            asm.iconst(i);
            asm.invokeVirtual(getIndex);
            asm.putfield(firstFieldIndex + i * 3);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static void generateUpdateEmpty(BytecodeAssembler asm, int fieldCount, int firstFieldIndex, int setEmptyIndex, int updateNameIndex, int updateSigIndex) {
        asm.startMethod(updateNameIndex, updateSigIndex, 3, 3);
        for (int i = 0; i < fieldCount; ++i) {
            asm.aload(0);
            asm.getfield(firstFieldIndex + i * 3);
            asm.aload(1);
            asm.invokeInterface(setEmptyIndex, 1);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static void generateUpdateExisting(BytecodeAssembler asm, int fieldCount, int firstFieldIndex, int computeNextIndex, int updateNameIndex, int updateSigIndex) {
        asm.startMethod(updateNameIndex, updateSigIndex, 5, 5);
        for (int i = 0; i < fieldCount; ++i) {
            asm.aload(0);
            asm.getfield(firstFieldIndex + i * 3);
            asm.aload(1);
            asm.aload(2);
            asm.lload(3);
            asm.invokeInterface(computeNextIndex, 4);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }

    private static void generateUpdateNew(BytecodeAssembler asm, int fieldCount, int firstFieldIndex, int computeFirstIndex, int updateNameIndex, int updateSigIndex) {
        asm.startMethod(updateNameIndex, updateSigIndex, 5, 5);
        for (int i = 0; i < fieldCount; ++i) {
            asm.aload(0);
            asm.getfield(firstFieldIndex + i * 3);
            asm.aload(1);
            asm.aload(2);
            asm.lload(3);
            asm.invokeInterface(computeFirstIndex, 4);
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
    }
}

