/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Hash;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class GroupByLong256HashSet {
    private static final long HEADER_SIZE = 16L;
    private static final int MIN_INITIAL_CAPACITY = 2;
    private static final long SIZE_LIMIT_OFFSET = 8L;
    private static final long SIZE_OFFSET = 4L;
    private final int initialCapacity;
    private final double loadFactor;
    private final long noKeyValue;
    private GroupByAllocator allocator;
    private long mask;
    private long ptr;

    public GroupByLong256HashSet(int initialCapacity, double loadFactor, long noKeyValue) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.initialCapacity = Numbers.ceilPow2((int)((double)Math.max(initialCapacity, 2) / loadFactor));
        this.loadFactor = loadFactor;
        this.noKeyValue = noKeyValue;
    }

    public boolean add(long k0, long k1, long k2, long k3) {
        long index = this.keyIndex(k0, k1, k2, k3);
        if (index < 0L) {
            return false;
        }
        this.addAt(index, k0, k1, k2, k3);
        return true;
    }

    public void addAt(long index, long k0, long k1, long k2, long k3) {
        this.setKeyAt(index, k0, k1, k2, k3);
        int size = this.size();
        int sizeLimit = this.sizeLimit();
        Unsafe.getUnsafe().putInt(this.ptr + 4L, ++size);
        if (size >= sizeLimit) {
            this.rehash(this.capacity() << 1, sizeLimit << 1);
        }
    }

    public int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr) : 0;
    }

    public long keyAddrAt(long index) {
        return this.ptr + 16L + 32L * index;
    }

    public long keyIndex(long k0, long k1, long k2, long k3) {
        long hashCode = Hash.hashLong256_64(k0, k1, k2, k3);
        long index = hashCode & this.mask;
        long p = this.keyAddrAt(index);
        long k0Key = Unsafe.getUnsafe().getLong(p);
        long k1Key = Unsafe.getUnsafe().getLong(p + 8L);
        long k2Key = Unsafe.getUnsafe().getLong(p + 16L);
        long k3Key = Unsafe.getUnsafe().getLong(p + 24L);
        if (k0Key == this.noKeyValue && k1Key == this.noKeyValue && k2Key == this.noKeyValue && k3Key == this.noKeyValue) {
            return index;
        }
        if (k0Key == k0 && k1Key == k1 && k2Key == k2 && k3Key == k3) {
            return -index - 1L;
        }
        return this.probe(k0, k1, k2, k3, index);
    }

    public void merge(GroupByLong256HashSet srcSet) {
        long lim = srcSet.ptr + 16L + 32L * (long)srcSet.capacity();
        for (long p = srcSet.ptr + 16L; p < lim; p += 32L) {
            long index;
            long k0 = Unsafe.getUnsafe().getLong(p);
            long k1 = Unsafe.getUnsafe().getLong(p + 8L);
            long k2 = Unsafe.getUnsafe().getLong(p + 16L);
            long k3 = Unsafe.getUnsafe().getLong(p + 24L);
            if (k0 == this.noKeyValue && k1 == this.noKeyValue && k2 == this.noKeyValue && k3 == this.noKeyValue || (index = this.keyIndex(k0, k1, k2, k3)) < 0L) continue;
            this.addAt(index, k0, k1, k2, k3);
        }
    }

    public GroupByLong256HashSet of(long ptr) {
        if (ptr == 0L) {
            this.ptr = this.allocator.malloc(16L + 32L * (long)this.initialCapacity);
            this.zero(this.ptr, this.initialCapacity);
            Unsafe.getUnsafe().putInt(this.ptr, this.initialCapacity);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            Unsafe.getUnsafe().putInt(this.ptr + 8L, (int)((double)this.initialCapacity * this.loadFactor));
            this.mask = this.initialCapacity - 1;
        } else {
            this.ptr = ptr;
            this.mask = this.capacity() - 1;
        }
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    public void resetPtr() {
        this.ptr = 0L;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    public int size() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 4L) : 0;
    }

    public int sizeLimit() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 8L) : 0;
    }

    private long probe(long k0, long k1, long k2, long k3, long index) {
        long index0 = index;
        do {
            index = index + 1L & this.mask;
            long p = this.keyAddrAt(index);
            long k0Key = Unsafe.getUnsafe().getLong(p);
            long k1Key = Unsafe.getUnsafe().getLong(p + 8L);
            long k2Key = Unsafe.getUnsafe().getLong(p + 16L);
            long k3Key = Unsafe.getUnsafe().getLong(p + 24L);
            if (k0Key == this.noKeyValue && k1Key == this.noKeyValue && k2Key == this.noKeyValue && k3Key == this.noKeyValue) {
                return index;
            }
            if (k0Key != k0 || k1Key != k1 || k2Key != k2 || k3Key != k3) continue;
            return -index - 1L;
        } while (index != index0);
        throw CairoException.critical(0).put("corrupt long256 hash set");
    }

    private void rehash(int newCapacity, int newSizeLimit) {
        if (newCapacity < 0) {
            throw CairoException.nonCritical().put("long256 hash set capacity overflow");
        }
        int oldSize = this.size();
        int oldCapacity = this.capacity();
        long oldPtr = this.ptr;
        this.ptr = this.allocator.malloc(32L * (long)newCapacity + 16L);
        this.zero(this.ptr, newCapacity);
        Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
        Unsafe.getUnsafe().putInt(this.ptr + 4L, oldSize);
        Unsafe.getUnsafe().putInt(this.ptr + 8L, newSizeLimit);
        this.mask = newCapacity - 1;
        long lim = oldPtr + 16L + 32L * (long)oldCapacity;
        for (long p = oldPtr + 16L; p < lim; p += 32L) {
            long k0 = Unsafe.getUnsafe().getLong(p);
            long k1 = Unsafe.getUnsafe().getLong(p + 8L);
            long k2 = Unsafe.getUnsafe().getLong(p + 16L);
            long k3 = Unsafe.getUnsafe().getLong(p + 24L);
            if (k0 == this.noKeyValue && k1 == this.noKeyValue && k2 == this.noKeyValue && k3 == this.noKeyValue) continue;
            long index = this.keyIndex(k0, k1, k2, k3);
            this.setKeyAt(index, k0, k1, k2, k3);
        }
        this.allocator.free(oldPtr, 16L + 32L * (long)oldCapacity);
    }

    private void setKeyAt(long index, long k0, long k1, long k2, long k3) {
        long p = this.keyAddrAt(index);
        Unsafe.getUnsafe().putLong(p, k0);
        Unsafe.getUnsafe().putLong(p + 8L, k1);
        Unsafe.getUnsafe().putLong(p + 16L, k2);
        Unsafe.getUnsafe().putLong(p + 24L, k3);
    }

    private void zero(long ptr, int cap) {
        if (this.noKeyValue == 0L) {
            Vect.memset(ptr + 16L, 32L * (long)cap, 0);
        } else {
            long lim = ptr + 16L + 32L * (long)cap;
            for (long p = ptr + 16L; p < lim; p += 32L) {
                Unsafe.getUnsafe().putLong(p, this.noKeyValue);
                Unsafe.getUnsafe().putLong(p + 8L, this.noKeyValue);
                Unsafe.getUnsafe().putLong(p + 16L, this.noKeyValue);
                Unsafe.getUnsafe().putLong(p + 24L, this.noKeyValue);
            }
        }
    }
}

