/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;

public class MonthTimestampSampler
implements TimestampSampler {
    private final int stepMonths;
    private int startDay;
    private int startHour;
    private int startMicros;
    private int startMillis;
    private int startMin;
    private int startSec;

    public MonthTimestampSampler(int stepMonths) {
        this.stepMonths = stepMonths;
    }

    @Override
    public long getApproxBucketSize() {
        return 2592000000000L * (long)this.stepMonths;
    }

    @Override
    public long nextTimestamp(long timestamp) {
        return this.addMonth(timestamp, this.stepMonths);
    }

    @Override
    public long nextTimestamp(long timestamp, int numSteps) {
        return this.addMonth(timestamp, numSteps * this.stepMonths);
    }

    @Override
    public long previousTimestamp(long timestamp) {
        return this.addMonth(timestamp, -this.stepMonths);
    }

    @Override
    public long round(long value) {
        int y = Timestamps.getYear(value);
        boolean leap = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(value, y, leap);
        int nextMonth = (m - 1) / this.stepMonths * this.stepMonths + 1;
        int d = this.startDay > 0 ? this.startDay : 1;
        return Timestamps.toMicros(y, leap, d, nextMonth, this.startHour, this.startMin, this.startSec, this.startMillis, this.startMicros);
    }

    @Override
    public void setStart(long timestamp) {
        int y = Timestamps.getYear(timestamp);
        boolean leap = Timestamps.isLeapYear(y);
        this.startDay = Timestamps.getDayOfMonth(timestamp, y, Timestamps.getMonthOfYear(timestamp, y, leap), leap);
        this.startHour = Timestamps.getHourOfDay(timestamp);
        this.startMin = Timestamps.getMinuteOfHour(timestamp);
        this.startSec = Timestamps.getSecondOfMinute(timestamp);
        this.startMillis = Timestamps.getMillisOfSecond(timestamp);
        this.startMicros = Timestamps.getMicrosOfMilli(timestamp);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("MonthTsSampler");
    }

    private long addMonth(long timestamp, int monthCount) {
        int _y;
        boolean leap;
        int y = Timestamps.getYear(timestamp);
        int m = Timestamps.getMonthOfYear(timestamp, y, leap = Timestamps.isLeapYear(y));
        int _m = m - 1 + monthCount;
        if (_m > -1) {
            _y = y + _m / 12;
            _m = _m % 12 + 1;
        } else {
            _y = y + _m / 12 - 1;
            if ((_m = -_m % 12) == 0) {
                _m = 12;
            }
            if ((_m = 12 - _m + 1) == 1) {
                ++_y;
            }
        }
        int _d = this.startDay;
        if (this.startDay == 0) {
            _d = 1;
        } else {
            int maxDay = Timestamps.getDaysPerMonth(_m, Timestamps.isLeapYear(_y));
            if (_d > maxDay) {
                _d = maxDay;
            }
        }
        return Timestamps.toMicros(_y, _m, _d) + (long)this.startHour * 3600000000L + (long)this.startMin * 60000000L + (long)this.startSec * 1000000L + (long)this.startMillis * 1000L + (long)this.startMicros;
    }
}

