/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.griffin.engine.groupby.AbstractSampleByFillRecordCursor;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.SimpleMapValuePeeker;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

public class SampleByFillValueNotKeyedRecordCursor
extends AbstractSampleByFillRecordCursor {
    private final SimpleMapValuePeeker peeker;
    private final SimpleMapValue simpleMapValue;
    private boolean endFill = false;
    private boolean firstRun = true;
    private boolean gapFill = false;
    private long upperBound = Long.MAX_VALUE;

    public SampleByFillValueNotKeyedRecordCursor(CairoConfiguration configuration, ObjList<GroupByFunction> groupByFunctions, GroupByFunctionsUpdater groupByFunctionsUpdater, ObjList<Function> recordFunctions, ObjList<Function> placeholderFunctions, SimpleMapValuePeeker peeker, int timestampIndex, TimestampSampler timestampSampler, SimpleMapValue simpleMapValue, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) {
        super(configuration, recordFunctions, timestampIndex, timestampSampler, groupByFunctions, groupByFunctionsUpdater, placeholderFunctions, timezoneNameFunc, timezoneNameFuncPos, offsetFunc, offsetFuncPos, sampleFromFunc, sampleFromFuncPos, sampleToFunc, sampleToFuncPos);
        this.simpleMapValue = simpleMapValue;
        this.record.of(simpleMapValue);
        this.peeker = peeker;
    }

    @Override
    public boolean hasNext() {
        long expectedLocalEpoch;
        this.initTimestamps();
        if (this.baseRecord == null && !this.gapFill && !this.endFill) {
            this.firstRun = true;
            return false;
        }
        if (this.firstRun) {
            expectedLocalEpoch = this.nextSampleLocalEpoch;
            this.firstRun = false;
        } else {
            expectedLocalEpoch = this.timestampSampler.nextTimestamp(this.nextSampleLocalEpoch);
        }
        if (expectedLocalEpoch < this.localEpoch) {
            this.setActiveB(expectedLocalEpoch);
            this.sampleLocalEpoch = expectedLocalEpoch;
            this.nextSampleLocalEpoch = expectedLocalEpoch;
            return true;
        }
        if (this.endFill) {
            this.sampleLocalEpoch = expectedLocalEpoch;
            this.nextSampleLocalEpoch = expectedLocalEpoch;
            this.endFill = false;
            this.gapFill = false;
            return this.localEpoch < this.upperBound;
        }
        if (this.setActiveA(expectedLocalEpoch)) {
            return this.peeker.reset();
        }
        boolean hasNext = this.notKeyedLoop(this.simpleMapValue);
        if (this.baseRecord == null && this.sampleToFunc != TimestampConstant.NULL && !this.endFill) {
            this.endFill = true;
            this.upperBound = this.sampleToFunc.getTimestamp(null);
            this.nextSamplePeriod(this.upperBound);
        }
        return hasNext;
    }

    @Override
    public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        super.of(baseCursor, executionContext);
        this.endFill = false;
        this.upperBound = Long.MAX_VALUE;
        this.firstRun = true;
        this.peeker.clear();
    }

    @Override
    public void toTop() {
        super.toTop();
        this.endFill = false;
        this.upperBound = Long.MAX_VALUE;
        this.firstRun = true;
        this.peeker.clear();
    }

    private boolean setActiveA(long expectedLocalEpoch) {
        if (this.gapFill) {
            this.gapFill = false;
            this.record.setActiveA();
            this.sampleLocalEpoch = expectedLocalEpoch;
            this.nextSampleLocalEpoch = expectedLocalEpoch;
            return true;
        }
        return false;
    }

    private void setActiveB(long expectedLocalEpoch) {
        if (!this.gapFill) {
            this.record.setActiveB(this.sampleLocalEpoch, expectedLocalEpoch, this.localEpoch);
            if (this.endFill) {
                this.record.setInterpolationTarget(null);
            } else {
                this.record.setInterpolationTarget(this.peeker.peek());
            }
            this.gapFill = true;
        }
    }
}

