/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;

public class LtJoinNoKeyRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final LtJoinNoKeyJoinRecordCursor cursor;

    public LtJoinNoKeyRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit, long toleranceInterval) {
        super(metadata, null, masterFactory, slaveFactory);
        this.cursor = new LtJoinNoKeyJoinRecordCursor(columnSplit, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex(), toleranceInterval);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Lt Join");
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
    }

    private static class LtJoinNoKeyJoinRecordCursor
    extends AbstractJoinCursor {
        private final int masterTimestampIndex;
        private final OuterJoinRecord record;
        private final int slaveTimestampIndex;
        private final long toleranceInterval;
        private boolean isMasterHasNextPending;
        private long latestSlaveRowID = Long.MIN_VALUE;
        private boolean masterHasNext;
        private Record masterRecord;
        private long slaveATimestamp = Long.MIN_VALUE;
        private long slaveBTimestamp = Long.MIN_VALUE;
        private Record slaveRecA;
        private Record slaveRecB;

        public LtJoinNoKeyJoinRecordCursor(int columnSplit, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex, long toleranceInterval) {
            super(columnSplit);
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.toleranceInterval = toleranceInterval;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            this.masterCursor.calculateSize(circuitBreaker, counter);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (this.masterHasNext) {
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (masterTimestamp <= this.slaveATimestamp) {
                    this.isMasterHasNextPending = true;
                    this.adjustForTolerance(masterTimestamp);
                    return true;
                }
                this.nextSlave(masterTimestamp);
                this.isMasterHasNextPending = true;
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public void toTop() {
            this.slaveATimestamp = Long.MIN_VALUE;
            this.slaveBTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.record.hasSlave(false);
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.isMasterHasNextPending = true;
        }

        private void adjustForTolerance(long masterTimestamp) {
            if (this.toleranceInterval == Long.MIN_VALUE || !this.record.hasSlave()) {
                return;
            }
            this.record.hasSlave(this.slaveBTimestamp >= masterTimestamp - this.toleranceInterval);
        }

        private void nextSlave(long masterTimestamp) {
            block5: {
                block4: {
                    do {
                        boolean slaveHasNext = this.slaveCursor.hasNext();
                        if (this.latestSlaveRowID != Long.MIN_VALUE) {
                            this.record.hasSlave(true);
                            this.slaveCursor.recordAt(this.slaveRecB, this.latestSlaveRowID);
                        }
                        if (!slaveHasNext) break block4;
                        this.slaveATimestamp = this.slaveRecA.getTimestamp(this.slaveTimestampIndex);
                        this.latestSlaveRowID = this.slaveRecA.getRowId();
                    } while (this.slaveATimestamp < masterTimestamp);
                    break block5;
                }
                this.slaveATimestamp = Long.MAX_VALUE;
            }
            if (this.record.hasSlave()) {
                this.slaveBTimestamp = this.slaveRecB.getTimestamp(this.slaveTimestampIndex);
                long minSlaveTimestamp = this.toleranceInterval == Long.MIN_VALUE ? Long.MIN_VALUE : masterTimestamp - this.toleranceInterval;
                this.record.hasSlave(this.slaveBTimestamp >= minSlaveTimestamp);
            }
            assert (!this.record.hasSlave() || this.slaveBTimestamp < masterTimestamp);
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.slaveATimestamp = Long.MIN_VALUE;
            this.slaveBTimestamp = Long.MIN_VALUE;
            this.latestSlaveRowID = Long.MIN_VALUE;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecA = slaveCursor.getRecord();
            this.slaveRecB = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecB);
            this.record.hasSlave(false);
            this.isMasterHasNextPending = true;
        }
    }
}

