/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReduceTaskFactory;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.griffin.engine.orderby.RecordComparatorCompiler;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursorFactory;
import io.questdb.griffin.engine.orderby.SortedRecordCursorFactory;
import io.questdb.griffin.engine.table.AsyncFilterUtils;
import io.questdb.griffin.engine.table.AsyncTopKAtom;
import io.questdb.griffin.engine.table.AsyncTopKRecordCursor;
import io.questdb.jit.CompiledFilter;
import io.questdb.mp.SCSequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncTopKRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final PageFrameReducer FILTER_AND_FIND_TOP_K = AsyncTopKRecordCursorFactory::filterAndFindTopK;
    private static final PageFrameReducer FIND_TOP_K = AsyncTopKRecordCursorFactory::findTopK;
    private final RecordCursorFactory base;
    private final SCSequence collectSubSeq = new SCSequence();
    private final AsyncTopKRecordCursor cursor;
    private final PageFrameSequence<AsyncTopKAtom> frameSequence;
    private final long lo;
    private final ListColumnFilter orderByFilter;
    private final int workerCount;

    public AsyncTopKRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull RecordMetadata metadata, @NotNull RecordCursorFactory base, @NotNull PageFrameReduceTaskFactory reduceTaskFactory, @Nullable Function filter, @Nullable ObjList<Function> perWorkerFilters, @Nullable CompiledFilter compiledFilter, @Nullable MemoryCARW bindVarMemory, @Nullable ObjList<Function> bindVarFunctions, @NotNull RecordComparatorCompiler recordComparatorCompiler, @NotNull ListColumnFilter orderByFilter, @NotNull RecordMetadata orderByMetadata, long lo, int workerCount) {
        super(metadata);
        assert (!(base instanceof AsyncTopKRecordCursorFactory));
        try {
            this.base = base;
            AsyncTopKAtom atom = new AsyncTopKAtom(configuration, filter, perWorkerFilters, compiledFilter, bindVarMemory, bindVarFunctions, recordComparatorCompiler, orderByFilter, orderByMetadata, lo, workerCount);
            this.frameSequence = new PageFrameSequence<AsyncTopKAtom>(configuration, messageBus, atom, filter != null ? FILTER_AND_FIND_TOP_K : FIND_TOP_K, reduceTaskFactory, workerCount, 3);
            this.cursor = new AsyncTopKRecordCursor();
            this.orderByFilter = orderByFilter;
            this.lo = lo;
            this.workerCount = workerCount;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public PageFrameSequence<AsyncTopKAtom> execute(SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        return this.frameSequence.of(this.base, executionContext, collectSubSeq, order);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int order = this.base.getScanDirection() == 2 ? 1 : 0;
        this.cursor.of(this.execute(executionContext, this.collectSubSeq, order));
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return SortedRecordCursorFactory.getScanDirection(this.orderByFilter);
    }

    @Override
    public TableToken getTableToken() {
        return this.base.getTableToken();
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        if (this.usesCompiledFilter()) {
            sink.type("Async JIT Top K");
        } else {
            sink.type("Async Top K");
        }
        sink.meta("lo").val(this.lo);
        sink.meta("workers").val(this.workerCount);
        sink.optAttr((CharSequence)"filter", this.frameSequence.getAtom(), true);
        SortedLightRecordCursorFactory.addSortKeys(sink, this.orderByFilter);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.frameSequence.getAtom().getCompiledFilter() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterAndFindTopK(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        DirectLongList rows = task.getFilteredRows();
        PageFrameSequence<AsyncTopKAtom> frameSequence = task.getFrameSequence(AsyncTopKAtom.class);
        rows.clear();
        long frameRowCount = task.getFrameRowCount();
        assert (frameRowCount > 0L);
        AsyncTopKAtom atom = frameSequence.getAtom();
        boolean owner = stealingFrameSequence != null && stealingFrameSequence == frameSequence;
        try {
            int slotId = atom.maybeAcquire(workerId, owner, circuitBreaker);
            PageFrameMemoryPool frameMemoryPool = atom.getMemoryPool(slotId);
            PageFrameMemoryRecord recordB = atom.getRecordB(slotId);
            PageFrameMemory frameMemory = frameMemoryPool.navigateTo(task.getFrameIndex());
            record.init(frameMemory);
            LimitedSizeLongTreeChain chain = atom.getTreeChain(slotId);
            RecordComparator comparator = atom.getComparator(slotId);
            CompiledFilter compiledFilter = atom.getCompiledFilter();
            Function filter = atom.getFilter(slotId);
            try {
                if (compiledFilter == null || frameMemory.hasColumnTops()) {
                    AsyncFilterUtils.applyFilter(filter, rows, record, frameRowCount);
                } else {
                    AsyncFilterUtils.applyCompiledFilter(frameMemory, compiledFilter, atom.getBindVarMemory(), atom.getBindVarFunctions(), task);
                }
                long n = rows.size();
                for (long p = 0L; p < n; ++p) {
                    long r = rows.get(p);
                    record.setRowIndex(r);
                    chain.put(record, frameMemoryPool, recordB, comparator);
                }
            }
            finally {
                atom.release(slotId);
            }
        }
        finally {
            task.releaseFrameMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findTopK(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        long frameRowCount = task.getFrameRowCount();
        assert (frameRowCount > 0L);
        AsyncTopKAtom atom = task.getFrameSequence(AsyncTopKAtom.class).getAtom();
        boolean owner = stealingFrameSequence != null && stealingFrameSequence == task.getFrameSequence();
        try {
            int slotId = atom.maybeAcquire(workerId, owner, circuitBreaker);
            PageFrameMemoryPool frameMemoryPool = atom.getMemoryPool(slotId);
            PageFrameMemoryRecord recordB = atom.getRecordB(slotId);
            PageFrameMemory frameMemory = frameMemoryPool.navigateTo(task.getFrameIndex());
            record.init(frameMemory);
            LimitedSizeLongTreeChain chain = atom.getTreeChain(slotId);
            RecordComparator comparator = atom.getComparator(slotId);
            try {
                for (long r = 0L; r < frameRowCount; ++r) {
                    record.setRowIndex(r);
                    chain.put(record, frameMemoryPool, recordB, comparator);
                }
            }
            finally {
                atom.release(slotId);
            }
        }
        finally {
            task.releaseFrameMemory();
        }
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.free(this.frameSequence);
    }
}

