/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByAllSymbolsFilteredRecordCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByAllSymbolsFilteredRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    public LatestByAllSymbolsFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, @NotNull RecordSink recordSink, @NotNull ColumnTypes partitionByColumnTypes, @NotNull IntList partitionByColumnIndexes, @Nullable IntList partitionBySymbolCounts, @Nullable Function filter, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        try {
            Map map = MapFactory.createOrderedMap(configuration, partitionByColumnTypes);
            this.cursor = new LatestByAllSymbolsFilteredRecordCursor(configuration, metadata, map, this.rows, recordSink, filter, partitionByColumnIndexes, partitionBySymbolCounts);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestByAllSymbolsFiltered");
        sink.optAttr((CharSequence)"filter", ((LatestByAllSymbolsFilteredRecordCursor)this.cursor).getFilter());
        sink.child(this.cursor);
        sink.child(this.partitionFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.cursor);
    }
}

