/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.SymbolFunctionRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursor;

public class SymbolIndexFilteredRowCursorFactory
implements SymbolFunctionRowCursorFactory {
    private final int columnIndex;
    private final SymbolIndexFilteredRowCursor cursor;
    private final Function symbolFunction;

    public SymbolIndexFilteredRowCursorFactory(int columnIndex, int symbolKey, Function filter, boolean cachedIndexReaderCursor, int indexDirection, Function symbolFunction) {
        this.columnIndex = columnIndex;
        this.cursor = new SymbolIndexFilteredRowCursor(columnIndex, symbolKey, filter, cachedIndexReaderCursor, indexDirection);
        this.symbolFunction = symbolFunction;
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        return this.cursor.of(pageFrame, pageFrameMemory);
    }

    @Override
    public Function getFunction() {
        return this.symbolFunction;
    }

    @Override
    public int getSymbolKey() {
        return this.cursor.getSymbolKey() == 0 ? Integer.MIN_VALUE : this.cursor.getSymbolKey() - 1;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void of(int symbolKey) {
        this.cursor.of(symbolKey);
    }

    @Override
    public void prepareCursor(PageFrameCursor pageFrameCursor) {
        this.cursor.prepare(pageFrameCursor);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type(BitmapIndexReader.nameOf(this.cursor.getIndexDirection())).type(" scan").meta("on").putBaseColumnName(this.columnIndex);
        sink.attr("filter").putBaseColumnName(this.columnIndex).val('=').val(this.cursor.getSymbolKey()).val(" and ").val(this.cursor.getFilter());
    }
}

