/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table.parquet;

import io.questdb.cairo.SymbolMapWriter;
import io.questdb.griffin.engine.table.parquet.PartitionDescriptor;
import io.questdb.std.FilesFacade;

public class MappedMemoryPartitionDescriptor
extends PartitionDescriptor {
    private final FilesFacade ff;

    public MappedMemoryPartitionDescriptor(FilesFacade ff) {
        this.ff = ff;
    }

    @Override
    public void clear() {
        int columnCount = this.getColumnCount();
        for (long columnIndex = 0L; columnIndex < (long)columnCount; ++columnIndex) {
            long rawIndex = columnIndex * 9L;
            long columnAddr = this.columnData.get(rawIndex + 3L);
            long columnSize = this.columnData.get(rawIndex + 4L);
            this.ff.munmap(columnAddr, columnSize, 16);
            long columnSecondaryAddr = this.columnData.get(rawIndex + 5L);
            long columnSecondarySize = this.columnData.get(rawIndex + 6L);
            this.ff.munmap(columnSecondaryAddr, columnSecondarySize, 16);
            long symbolOffsetsAddr = this.columnData.get(rawIndex + 7L);
            long symbolOffsetsSize = this.columnData.get(rawIndex + 8L);
            long offsetsMemSize = SymbolMapWriter.keyToOffset((int)symbolOffsetsSize + 1);
            this.ff.munmap(symbolOffsetsAddr - 64L, offsetsMemSize, 16);
        }
        super.clear();
    }
}

